/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.material;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.delete.MaterialDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.id.IMaterialId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.material.IDeleteMaterialExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.material.IMapMaterialByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.material.IMaterialAuthorizationExecutor;
import ch.systemsx.cisd.common.collection.SimpleComparator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IMaterialTable;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPropertyPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteMaterialExecutor
extends AbstractDeleteEntityExecutor<Void, IMaterialId, MaterialPE, MaterialDeletionOptions>
implements IDeleteMaterialExecutor {
    private static final Comparator<Map.Entry<Integer, List<TechId>>> INVERSE_LEVEL_COMPARATOR = new SimpleComparator<Map.Entry<Integer, List<TechId>>, Integer>(){

        public Integer evaluate(Map.Entry<Integer, List<TechId>> item) {
            return -item.getKey().intValue();
        }
    };
    @Autowired
    private IMapMaterialByIdExecutor mapMaterialByIdExecutor;
    @Autowired
    private IMaterialAuthorizationExecutor authorizationExecutor;

    @Override
    protected Map<IMaterialId, MaterialPE> map(IOperationContext context, List<? extends IMaterialId> entityIds, MaterialDeletionOptions deletionOptions) {
        return this.mapMaterialByIdExecutor.map(context, entityIds);
    }

    @Override
    protected void checkAccess(IOperationContext context, IMaterialId entityId, MaterialPE entity) {
        this.authorizationExecutor.canDelete(context, entityId, entity);
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, MaterialPE entity) {
    }

    @Override
    protected Void delete(IOperationContext context, Collection<MaterialPE> materials, MaterialDeletionOptions deletionOptions) {
        Map<String, String> links = this.createLinks(materials);
        List<Map.Entry<Integer, List<TechId>>> entries = this.orderMaterialsByLevel(materials, links);
        IMaterialTable materialTable = this.businessObjectFactory.createMaterialTable(context.getSession());
        for (Map.Entry<Integer, List<TechId>> entry : entries) {
            materialTable.deleteByTechIds(entry.getValue(), deletionOptions.getReason());
        }
        return null;
    }

    private Map<String, String> createLinks(Collection<MaterialPE> materials) {
        HashMap<String, String> links = new HashMap<String, String>();
        for (MaterialPE material : materials) {
            Set<MaterialPropertyPE> properties = material.getProperties();
            for (MaterialPropertyPE property : properties) {
                MaterialPE materialProperty = property.getMaterialValue();
                if (materialProperty == null) continue;
                links.put(material.getPermId(), materialProperty.getPermId());
            }
        }
        return links;
    }

    private List<Map.Entry<Integer, List<TechId>>> orderMaterialsByLevel(Collection<MaterialPE> materials, Map<String, String> links) {
        HashMap<Integer, ArrayList<TechId>> levelMap = new HashMap<Integer, ArrayList<TechId>>();
        for (MaterialPE material : materials) {
            int level = this.getLevel(material.getPermId(), links, 0);
            ArrayList<TechId> ids = (ArrayList<TechId>)levelMap.get(level);
            if (ids == null) {
                ids = new ArrayList<TechId>();
                levelMap.put(level, ids);
            }
            ids.add(new TechId((IIdAndCodeHolder)material));
        }
        ArrayList<Map.Entry<Integer, List<TechId>>> entries = new ArrayList<Map.Entry<Integer, List<TechId>>>(levelMap.entrySet());
        Collections.sort(entries, INVERSE_LEVEL_COMPARATOR);
        return entries;
    }

    private int getLevel(String material, Map<String, String> links, int level) {
        String nextMaterial = links.get(material);
        if (nextMaterial == null) {
            return level;
        }
        return this.getLevel(nextMaterial, links, level + 1);
    }
}

