/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.objectkindmodification;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.objectkindmodification.ObjectKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.objectkindmodification.ObjectKindModification;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.objectkindmodification.OperationKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.objectkindmodification.fetchoptions.ObjectKindModificationFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.objectkindmodification.search.ObjectKindCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.objectkindmodification.search.ObjectKindModificationSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.objectkindmodification.search.OperationKindCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.objectkindmodification.IObjectKindModificationAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.objectkindmodification.ISearchObjectKindModificationExecutor;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LastModificationState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchObjectKindModificationExecutor
implements ISearchObjectKindModificationExecutor {
    @Autowired
    private LastModificationState lastModificationState;
    @Autowired
    private IObjectKindModificationAuthorizationExecutor authorizationExecutor;

    @Override
    public List<ObjectKindModification> search(IOperationContext context, ObjectKindModificationSearchCriteria searchCriteria, ObjectKindModificationFetchOptions fetchOptions) {
        this.authorizationExecutor.canSearch(context);
        ArrayList<ObjectKindModification> result = new ArrayList<ObjectKindModification>();
        List<ObjectKind> objectKinds = this.getObjectKinds(searchCriteria);
        List<OperationKind> operationKinds = this.getOperationKinds(searchCriteria);
        for (ObjectKind objectKind : objectKinds) {
            for (OperationKind operationKind : operationKinds) {
                ObjectKindModification objectKindModification = new ObjectKindModification();
                objectKindModification.setObjectKind(objectKind);
                objectKindModification.setOperationKind(operationKind);
                Date date = new Date(this.lastModificationState.getLastModificationTime(this.translate(objectKind, operationKind)));
                objectKindModification.setLastModificationTimeStamp(date);
                objectKindModification.setFetchOptions(fetchOptions);
                result.add(objectKindModification);
            }
        }
        return result;
    }

    private List<ObjectKind> getObjectKinds(ObjectKindModificationSearchCriteria searchCriteria) {
        ObjectKindCriteria lastCriteria = null;
        for (ISearchCriteria subCriteria : searchCriteria.getCriteria()) {
            if (!(subCriteria instanceof ObjectKindCriteria)) continue;
            lastCriteria = (ObjectKindCriteria)subCriteria;
        }
        if (lastCriteria == null || lastCriteria.getObjectKinds() == null || lastCriteria.getObjectKinds().isEmpty()) {
            return Arrays.asList(ObjectKind.values());
        }
        return lastCriteria.getObjectKinds();
    }

    private List<OperationKind> getOperationKinds(ObjectKindModificationSearchCriteria searchCriteria) {
        OperationKindCriteria lastCriteria = null;
        for (ISearchCriteria subCriteria : searchCriteria.getCriteria()) {
            if (!(subCriteria instanceof OperationKindCriteria)) continue;
            lastCriteria = (OperationKindCriteria)subCriteria;
        }
        if (lastCriteria == null || lastCriteria.getOperationKinds() == null || lastCriteria.getOperationKinds().isEmpty()) {
            return Arrays.asList(OperationKind.values());
        }
        return lastCriteria.getOperationKinds();
    }

    private DatabaseModificationKind translate(ObjectKind objectKind, OperationKind operationKind) {
        DatabaseModificationKind.ObjectKind translatedObjectKind = DatabaseModificationKind.ObjectKind.valueOf(objectKind.name());
        switch (operationKind) {
            case CREATE_OR_DELETE: {
                return DatabaseModificationKind.createOrDelete(translatedObjectKind);
            }
            case UPDATE: {
                return DatabaseModificationKind.edit(translatedObjectKind);
            }
        }
        return null;
    }
}

