/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationExecutionError;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.AsynchronousOperationExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.AsynchronousOperationExecutionResults;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.IOperationExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionError;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.id.OperationExecutionPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.IAsynchronousOperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.IAsynchronousOperationThreadPoolExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.IOperationExecutionIdFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.config.IOperationExecutionConfig;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.IOperationExecutionStore;
import ch.systemsx.cisd.base.namedthread.NamingThreadPoolExecutor;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsynchronousOperationExecutor
implements IAsynchronousOperationExecutor {
    private static final Logger log = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AsynchronousOperationExecutor.class);
    private NamingThreadPoolExecutor executionThreadPool;
    private IOperationExecutionIdFactory executionIdFactory;
    @Autowired
    private IOperationExecutionConfig executionConfig;
    @Autowired
    private IOperationExecutionStore executionStore;
    @Autowired
    private IAsynchronousOperationThreadPoolExecutor poolExecutor;

    public AsynchronousOperationExecutor() {
        this.executionIdFactory = new IOperationExecutionIdFactory(){

            @Override
            public OperationExecutionPermId createExecutionId(IOperationContext context) {
                return new OperationExecutionPermId();
            }
        };
    }

    AsynchronousOperationExecutor(IOperationExecutionConfig executionConfig, IOperationExecutionIdFactory executionIdFactory, IOperationExecutionStore executionStore, IAsynchronousOperationThreadPoolExecutor poolExecutor) {
        this.executionIdFactory = executionIdFactory;
        this.executionConfig = executionConfig;
        this.executionStore = executionStore;
        this.poolExecutor = poolExecutor;
        this.init();
    }

    @PostConstruct
    private void init() {
        this.executionThreadPool = new NamingThreadPoolExecutor(this.executionConfig.getThreadPoolName(), this.executionConfig.getThreadPoolCoreSize(), this.executionConfig.getThreadPoolMaxSize(), (long)this.executionConfig.getThreadPoolKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue()).daemonize();
    }

    @Override
    public AsynchronousOperationExecutionResults execute(final IOperationContext context, final List<? extends IOperation> operations, final AsynchronousOperationExecutionOptions options) {
        final OperationExecutionPermId executionId = this.executionIdFactory.createExecutionId(context);
        try {
            this.executionStore.executionNew(context, executionId, operations, (IOperationExecutionOptions)options);
            this.executionStore.executionScheduled(context, executionId);
            this.executionThreadPool.submit((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        AsynchronousOperationExecutor.this.executionStore.executionRunning(context, executionId);
                        List<IOperationResult> results = AsynchronousOperationExecutor.this.poolExecutor.execute(context, executionId, operations, (IOperationExecutionOptions)options);
                        AsynchronousOperationExecutor.this.executionStore.executionFinished(context, executionId, results);
                        return null;
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                        AsynchronousOperationExecutor.this.executionStore.executionFailed(context, executionId, (IOperationExecutionError)new OperationExecutionError(e));
                        throw e;
                    }
                }
            });
        }
        catch (Exception e) {
            log.error((Object)e);
            this.executionStore.executionFailed(context, executionId, (IOperationExecutionError)new OperationExecutionError(e));
            throw e;
        }
        return new AsynchronousOperationExecutionResults(executionId);
    }

    public void shutdown() {
        if (this.executionThreadPool != null) {
            this.executionThreadPool.shutdown();
        }
    }
}

