/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.AsynchronousOperationExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.IOperationExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.IOperationExecutionResults;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.SynchronousOperationExecutionOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.OperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.IAsynchronousOperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.IExecuteOperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.ISynchronousOperationExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecuteOperationExecutor
implements IExecuteOperationExecutor {
    @Autowired
    private ISynchronousOperationExecutor synchronousExecutor;
    @Autowired
    private IAsynchronousOperationExecutor asynchronousExecutor;

    @Override
    @Transactional
    public IOperationExecutionResults execute(Session session, List<? extends IOperation> operations, IOperationExecutionOptions options) {
        if (options instanceof SynchronousOperationExecutionOptions) {
            return this.synchronousExecutor.execute(new OperationContext(session, false), operations, (SynchronousOperationExecutionOptions)options);
        }
        if (options instanceof AsynchronousOperationExecutionOptions) {
            return this.asynchronousExecutor.execute(new OperationContext(session, true), operations, (AsynchronousOperationExecutionOptions)options);
        }
        throw new IllegalArgumentException("Operation execution options " + options + " are not supported");
    }
}

