/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.id.IOperationExecutionId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.id.OperationExecutionPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.IOperationExecutionAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationServiceUtils;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseCreateOrDeleteModification;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseUpdateModification;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import org.springframework.stereotype.Component;

@Component
public class OperationExecutionAuthorizationExecutor
implements IOperationExecutionAuthorizationExecutor {
    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="GET_OPERATION_EXECUTION")
    public void canGet(IOperationContext context) {
    }

    @Override
    public boolean canGet(IOperationContext context, OperationExecutionPE execution) {
        PersonPE person = context.getSession().tryGetPerson();
        if (person.getId().equals(execution.getOwner().getId())) {
            return true;
        }
        AuthorizationServiceUtils authorization = new AuthorizationServiceUtils(null, context.getSession().tryGetPerson());
        return authorization.doesUserHaveRole(RoleWithHierarchy.RoleCode.OBSERVER.toString(), null);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="UPDATE_OPERATION_EXECUTION")
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.OPERATION_EXECUTION})
    public void canUpdate(IOperationContext context, IOperationExecutionId id, OperationExecutionPE execution) {
        if (!this.canGet(context, execution)) {
            throw new UnauthorizedObjectAccessException((IObjectId)new OperationExecutionPermId(execution.getCode()));
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="DELETE_OPERATION_EXECUTION")
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.OPERATION_EXECUTION, DatabaseModificationKind.ObjectKind.DELETION})
    public void canDelete(IOperationContext context, IOperationExecutionId id, OperationExecutionPE execution) {
        if (!this.canGet(context, execution)) {
            throw new UnauthorizedObjectAccessException((IObjectId)new OperationExecutionPermId(execution.getCode()));
        }
    }
}

