/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationExecutionError;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.IOperationExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionError;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.SynchronousOperationExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.SynchronousOperationExecutionResults;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.id.OperationExecutionPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.IOperationsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.ISynchronousOperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.IOperationExecutionStore;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SynchronousOperationExecutor
implements ISynchronousOperationExecutor {
    private static final Logger log = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, SynchronousOperationExecutor.class);
    @Autowired
    private IOperationExecutionStore executionStore;
    @Autowired
    private IOperationsExecutor operationsExecutor;

    public SynchronousOperationExecutor() {
    }

    SynchronousOperationExecutor(IOperationExecutionStore executionStore, IOperationsExecutor operationsExecutor) {
        this.executionStore = executionStore;
        this.operationsExecutor = operationsExecutor;
    }

    @Override
    public SynchronousOperationExecutionResults execute(IOperationContext context, List<? extends IOperation> operations, SynchronousOperationExecutionOptions options) {
        OperationExecutionPermId executionId = options.getExecutionId();
        if (executionId == null && options.getNotification() != null) {
            throw new UserFailureException("Synchronous operation execution must have an execution id specified for a notification to work.");
        }
        try {
            if (executionId != null) {
                this.executionStore.executionNew(context, executionId, operations, (IOperationExecutionOptions)options);
                this.executionStore.executionRunning(context, executionId);
            }
            List<IOperationResult> results = this.operationsExecutor.execute(context, operations, (IOperationExecutionOptions)options);
            if (executionId != null) {
                this.executionStore.executionFinished(context, executionId, results);
            }
            return new SynchronousOperationExecutionResults(results);
        }
        catch (Exception e) {
            log.error((Object)e);
            if (executionId != null) {
                this.executionStore.executionFailed(context, executionId, (IOperationExecutionError)new OperationExecutionError(e));
            }
            throw e;
        }
    }
}

