/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.config;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.config.IOperationExecutionConfig;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Component;

@Component
public class OperationExecutionConfig
implements IOperationExecutionConfig {
    private static final int DAY_IN_SECONDS = 86400;
    private static final int MONTH_IN_SECONDS = 2592000;
    private static final int YEAR_IN_SECONDS = 31536000;
    private static final String PREFIX = "api.v3.operation-execution.";
    private static final String STORE_PREFIX = "api.v3.operation-execution.store.";
    private static final String THREAD_POOL_PREFIX = "api.v3.operation-execution.thread-pool.";
    private static final String PROGRESS_PREFIX = "api.v3.operation-execution.progress.";
    private static final String STATE_UPDATE_PREFIX = "api.v3.operation-execution.state-update.";
    private static final String AVAILABILITY_TIME_PREFIX = "api.v3.operation-execution.availability-time.";
    private static final String AVAILABILITY_UPDATE_PREFIX = "api.v3.operation-execution.availability-update.";
    private static final String SUMMARY_AVAILABILITY_TIME_PREFIX = "api.v3.operation-execution.availability-time.summary.";
    private static final String DETAILS_AVAILABILITY_TIME_PREFIX = "api.v3.operation-execution.availability-time.details.";
    private static final String MARK_TIMEOUT_PENDING_TASK_PREFIX = "api.v3.operation-execution.availability-update.mark-timeout-pending-task.";
    private static final String MARK_TIMED_OUT_OR_DELETED_TASK_PREFIX = "api.v3.operation-execution.availability-update.mark-timed-out-or-deleted-task.";
    private static final String MARK_FAILED_AFTER_SERVER_RESTART_TASK_PREFIX = "api.v3.operation-execution.state-update.mark-failed-after-server-restart-task.";
    private static final String CACHE_PREFIX = "api.v3.operation-execution.cache.";
    public static final String STORE_PATH = "api.v3.operation-execution.store.path";
    public static final String THREAD_POOL_NAME = "api.v3.operation-execution.thread-pool.name";
    public static final String THREAD_POOL_CORE_SIZE = "api.v3.operation-execution.thread-pool.core-size";
    public static final String THREAD_POOL_MAX_SIZE = "api.v3.operation-execution.thread-pool.max-size";
    public static final String THREAD_POOL_KEEP_ALIVE_TIME = "api.v3.operation-execution.thread-pool.keep-alive-time";
    public static final String PROGRESS_THREAD_NAME = "api.v3.operation-execution.progress.thread-name";
    public static final String PROGRESS_INTERVAL = "api.v3.operation-execution.progress.interval";
    public static final String AVAILABILITY_TIME_DEFAULT = "api.v3.operation-execution.availability-time.default";
    public static final String AVAILABILITY_TIME_MAX = "api.v3.operation-execution.availability-time.max";
    public static final String SUMMARY_AVAILABILITY_TIME_DEFAULT = "api.v3.operation-execution.availability-time.summary.default";
    public static final String SUMMARY_AVAILABILITY_TIME_MAX = "api.v3.operation-execution.availability-time.summary.max";
    public static final String DETAILS_AVAILABILITY_TIME_DEFAULT = "api.v3.operation-execution.availability-time.details.default";
    public static final String DETAILS_AVAILABILITY_TIME_MAX = "api.v3.operation-execution.availability-time.details.max";
    public static final String MARK_TIMEOUT_PENDING_TASK_NAME = "api.v3.operation-execution.availability-update.mark-timeout-pending-task.name";
    public static final String MARK_TIMEOUT_PENDING_TASK_INTERVAL = "api.v3.operation-execution.availability-update.mark-timeout-pending-task.interval";
    public static final String MARK_TIMED_OUT_OR_DELETED_TASK_NAME = "api.v3.operation-execution.availability-update.mark-timed-out-or-deleted-task.name";
    public static final String MARK_TIMED_OUT_OR_DELETED_TASK_INTERVAL = "api.v3.operation-execution.availability-update.mark-timed-out-or-deleted-task.interval";
    public static final String MARK_FAILED_AFTER_SERVER_RESTART_TASK_NAME = "api.v3.operation-execution.state-update.mark-failed-after-server-restart-task.name";
    public static final String CACHE_CLEARANCE_TASK_NAME = "api.v3.operation-execution.cache.clearance-task-name";
    public static final String CACHE_CLEARANCE_TASK_INTERVAL = "api.v3.operation-execution.cache.timeout-check-interval";
    public static final String CACHE_CLEARANCE_TIMEOUT = "api.v3.operation-execution.cache.timeout";
    public static final String CACHE_CLASS = "api.v3.operation-execution.cache.class";
    public static final String CACHE_DIRECTORY = "api.v3.operation-execution.cache.directory";
    public static final String CACHE_CAPACITY = "api.v3.operation-execution.cache.capacity";
    private static final String STORE_PATH_DEFAULT = "operation-execution-store";
    private static final String THREAD_POOL_NAME_DEFAULT = "operation-execution-pool";
    private static final int THREAD_POOL_CORE_SIZE_DEFAULT = 10;
    private static final int THREAD_POOL_MAX_SIZE_DEFAULT = 10;
    private static final int THREAD_POOL_KEEP_ALIVE_TIME_DEFAULT = 0;
    private static final String PROGRESS_THREAD_NAME_DEFAULT = "operation-execution-progress";
    private static final int PROGRESS_INTERVAL_DEFAULT = 5;
    private static final int AVAILABILITY_TIME_DEFAULT_DEFAULT = 31536000;
    private static final int AVAILABILITY_TIME_MAX_DEFAULT = 31536000;
    private static final int SUMMARY_AVAILABILITY_TIME_DEFAULT_DEFAULT = 2592000;
    private static final int SUMMARY_AVAILABILITY_TIME_MAX_DEFAULT = 2592000;
    private static final int DETAILS_AVAILABILITY_TIME_DEFAULT_DEFAULT = 86400;
    private static final int DETAILS_AVAILABILITY_TIME_MAX_DEFAULT = 86400;
    private static final String MARK_TIMEOUT_PENDING_TASK_NAME_DEFAULT = "operation-execution-mark-timeout-pending-task";
    private static final int MARK_TIMEOUT_PENDING_TASK_INTERVAL_DEFAULT = 60;
    private static final String MARK_TIMED_OUT_OR_DELETED_TASK_NAME_DEFAULT = "operation-execution-mark-timed-out-or-deleted-task";
    private static final int MARK_TIMED_OUT_OR_DELETED_TASK_INTERVAL_DEFAULT = 300;
    private static final String MARK_FAILED_AFTER_SERVER_RESTART_TASK_NAME_DEFAULT = "operation-execution-mark-failed-after-server-restart-task";
    private static final String CACHE_CLEARANCE_TASK_NAME_DEFAULT = "cache-clearance-task";
    private static final int CACHE_CLEARANCE_TASK_INTERVAL_DEFAULT = 300;
    public static final int CACHE_CLEARANCE_TIMEOUT_DEFAULT = 3600;
    public static final int CACHE_CAPACITY_DEFAULT = 10240;
    public static final String CACHE_DIRECTORY_DEFAULT = "targets/sessionWorkspace/cache";
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;
    private boolean initialized = false;
    private String storePath;
    private String threadPoolName;
    private int threadPoolCoreSize;
    private int threadPoolMaxSize;
    private int threadPoolKeepAliveTime;
    private String progressThreadName;
    private int progressInterval;
    private int availabilityTimeDefault;
    private int availabilityTimeMax;
    private int summaryAvailabilityTimeDefault;
    private int summaryAvailabilityTimeMax;
    private int detailsAvailabilityTimeDefault;
    private int detailsAvailabilityTimeMax;
    private String markFailedAfterServerRestartTaskName;
    private String markTimeOutPendingTaskName;
    private int markTimeOutPendingTaskInterval;
    private String markTimedOutOrDeletedTaskName;
    private int markTimedOutOrDeletedTaskInterval;
    private String cacheClearanceTaskName;
    private int cacheClearanceTaskInterval;

    @PostConstruct
    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Properties properties = this.getProperties();
        this.storePath = OperationExecutionConfig.getStringPropertyOrDefault(properties, STORE_PATH, STORE_PATH_DEFAULT);
        this.threadPoolName = OperationExecutionConfig.getStringPropertyOrDefault(properties, THREAD_POOL_NAME, THREAD_POOL_NAME_DEFAULT);
        this.threadPoolCoreSize = OperationExecutionConfig.getIntegerPropertyOrDefault(properties, THREAD_POOL_CORE_SIZE, 10);
        OperationExecutionConfig.checkPositiveProperty(properties, THREAD_POOL_CORE_SIZE, this.threadPoolCoreSize);
        this.threadPoolMaxSize = OperationExecutionConfig.getIntegerPropertyOrDefault(properties, THREAD_POOL_MAX_SIZE, 10);
        OperationExecutionConfig.checkGreaterThanOrEqualToOtherProperty(properties, THREAD_POOL_MAX_SIZE, this.threadPoolMaxSize, THREAD_POOL_CORE_SIZE, this.threadPoolCoreSize);
        this.threadPoolKeepAliveTime = OperationExecutionConfig.getIntegerPropertyOrDefault(properties, THREAD_POOL_KEEP_ALIVE_TIME, 0);
        OperationExecutionConfig.checkPositiveOrZeroProperty(properties, THREAD_POOL_KEEP_ALIVE_TIME, this.threadPoolKeepAliveTime);
        this.progressThreadName = OperationExecutionConfig.getStringPropertyOrDefault(properties, PROGRESS_THREAD_NAME, PROGRESS_THREAD_NAME_DEFAULT);
        this.progressInterval = OperationExecutionConfig.getIntegerPropertyOrDefault(properties, PROGRESS_INTERVAL, 5);
        OperationExecutionConfig.checkPositiveProperty(properties, PROGRESS_INTERVAL, this.progressInterval);
        this.availabilityTimeDefault = OperationExecutionConfig.getIntegerPropertyOrDefault(properties, AVAILABILITY_TIME_DEFAULT, 31536000);
        OperationExecutionConfig.checkPositiveOrZeroProperty(properties, AVAILABILITY_TIME_DEFAULT, this.availabilityTimeDefault);
        this.availabilityTimeMax = OperationExecutionConfig.getIntegerPropertyOrDefault(properties, AVAILABILITY_TIME_MAX, 31536000);
        OperationExecutionConfig.checkGreaterThanOrEqualToOtherProperty(properties, AVAILABILITY_TIME_MAX, this.availabilityTimeMax, AVAILABILITY_TIME_DEFAULT, this.availabilityTimeDefault);
        this.summaryAvailabilityTimeDefault = OperationExecutionConfig.getIntegerPropertyOrDefault(properties, SUMMARY_AVAILABILITY_TIME_DEFAULT, 2592000);
        OperationExecutionConfig.checkPositiveOrZeroProperty(properties, SUMMARY_AVAILABILITY_TIME_DEFAULT, this.summaryAvailabilityTimeDefault);
        this.summaryAvailabilityTimeMax = OperationExecutionConfig.getIntegerPropertyOrDefault(properties, SUMMARY_AVAILABILITY_TIME_MAX, 2592000);
        OperationExecutionConfig.checkGreaterThanOrEqualToOtherProperty(properties, SUMMARY_AVAILABILITY_TIME_MAX, this.summaryAvailabilityTimeMax, SUMMARY_AVAILABILITY_TIME_DEFAULT, this.summaryAvailabilityTimeDefault);
        this.detailsAvailabilityTimeDefault = OperationExecutionConfig.getIntegerPropertyOrDefault(properties, DETAILS_AVAILABILITY_TIME_DEFAULT, 86400);
        OperationExecutionConfig.checkPositiveOrZeroProperty(properties, DETAILS_AVAILABILITY_TIME_DEFAULT, this.detailsAvailabilityTimeDefault);
        this.detailsAvailabilityTimeMax = OperationExecutionConfig.getIntegerPropertyOrDefault(properties, DETAILS_AVAILABILITY_TIME_MAX, 86400);
        OperationExecutionConfig.checkGreaterThanOrEqualToOtherProperty(properties, DETAILS_AVAILABILITY_TIME_MAX, this.detailsAvailabilityTimeMax, DETAILS_AVAILABILITY_TIME_DEFAULT, this.detailsAvailabilityTimeDefault);
        this.markTimeOutPendingTaskName = OperationExecutionConfig.getStringPropertyOrDefault(properties, MARK_TIMEOUT_PENDING_TASK_NAME, MARK_TIMEOUT_PENDING_TASK_NAME_DEFAULT);
        this.markTimeOutPendingTaskInterval = OperationExecutionConfig.getIntegerPropertyOrDefault(properties, MARK_TIMEOUT_PENDING_TASK_INTERVAL, 60);
        OperationExecutionConfig.checkPositiveProperty(properties, MARK_TIMEOUT_PENDING_TASK_INTERVAL, this.markTimeOutPendingTaskInterval);
        this.markTimedOutOrDeletedTaskName = OperationExecutionConfig.getStringPropertyOrDefault(properties, MARK_TIMED_OUT_OR_DELETED_TASK_NAME, MARK_TIMED_OUT_OR_DELETED_TASK_NAME_DEFAULT);
        this.markTimedOutOrDeletedTaskInterval = OperationExecutionConfig.getIntegerPropertyOrDefault(properties, MARK_TIMED_OUT_OR_DELETED_TASK_INTERVAL, 300);
        OperationExecutionConfig.checkPositiveProperty(properties, MARK_TIMED_OUT_OR_DELETED_TASK_INTERVAL, this.markTimedOutOrDeletedTaskInterval);
        this.markFailedAfterServerRestartTaskName = OperationExecutionConfig.getStringPropertyOrDefault(properties, MARK_FAILED_AFTER_SERVER_RESTART_TASK_NAME, MARK_FAILED_AFTER_SERVER_RESTART_TASK_NAME_DEFAULT);
        this.cacheClearanceTaskName = OperationExecutionConfig.getStringPropertyOrDefault(properties, CACHE_CLEARANCE_TASK_NAME, CACHE_CLEARANCE_TASK_NAME_DEFAULT);
        this.cacheClearanceTaskInterval = OperationExecutionConfig.getIntegerPropertyOrDefault(properties, CACHE_CLEARANCE_TASK_INTERVAL, 300);
        OperationExecutionConfig.checkPositiveProperty(properties, CACHE_CLEARANCE_TASK_INTERVAL, this.cacheClearanceTaskInterval);
    }

    @Override
    public String getStorePath() {
        this.init();
        return this.storePath;
    }

    @Override
    public String getThreadPoolName() {
        this.init();
        return this.threadPoolName;
    }

    @Override
    public int getThreadPoolCoreSize() {
        this.init();
        return this.threadPoolCoreSize;
    }

    @Override
    public int getThreadPoolMaxSize() {
        this.init();
        return this.threadPoolMaxSize;
    }

    @Override
    public int getThreadPoolKeepAliveTime() {
        this.init();
        return this.threadPoolKeepAliveTime;
    }

    @Override
    public String getProgressThreadName() {
        this.init();
        return this.progressThreadName;
    }

    @Override
    public int getProgressInterval() {
        this.init();
        return this.progressInterval;
    }

    @Override
    public int getAvailabilityTimeOrDefault(Integer availabilityTimeOrNull) {
        this.init();
        return OperationExecutionConfig.getAvailabilityTimeOrDefault(availabilityTimeOrNull, this.getAvailabilityTimeDefault(), this.getAvailabilityTimeMax());
    }

    @Override
    public int getAvailabilityTimeDefault() {
        this.init();
        return this.availabilityTimeDefault;
    }

    @Override
    public int getAvailabilityTimeMax() {
        this.init();
        return this.availabilityTimeMax;
    }

    @Override
    public int getSummaryAvailabilityTimeOrDefault(Integer summaryAvailabilityTimeOrNull) {
        this.init();
        return OperationExecutionConfig.getAvailabilityTimeOrDefault(summaryAvailabilityTimeOrNull, this.getSummaryAvailabilityTimeDefault(), this.getSummaryAvailabilityTimeMax());
    }

    @Override
    public int getSummaryAvailabilityTimeDefault() {
        this.init();
        return this.summaryAvailabilityTimeDefault;
    }

    @Override
    public int getSummaryAvailabilityTimeMax() {
        this.init();
        return this.summaryAvailabilityTimeMax;
    }

    @Override
    public int getDetailsAvailabilityTimeOrDefault(Integer detailsAvailabilityTimeOrNull) {
        this.init();
        return OperationExecutionConfig.getAvailabilityTimeOrDefault(detailsAvailabilityTimeOrNull, this.getDetailsAvailabilityTimeDefault(), this.getDetailsAvailabilityTimeMax());
    }

    @Override
    public int getDetailsAvailabilityTimeDefault() {
        this.init();
        return this.detailsAvailabilityTimeDefault;
    }

    @Override
    public int getDetailsAvailabilityTimeMax() {
        this.init();
        return this.detailsAvailabilityTimeMax;
    }

    @Override
    public String getMarkFailedAfterServerRestartTaskName() {
        this.init();
        return this.markFailedAfterServerRestartTaskName;
    }

    @Override
    public String getMarkTimeOutPendingTaskName() {
        this.init();
        return this.markTimeOutPendingTaskName;
    }

    @Override
    public int getMarkTimeOutPendingTaskInterval() {
        this.init();
        return this.markTimeOutPendingTaskInterval;
    }

    @Override
    public String getMarkTimedOutOrDeletedTaskName() {
        this.init();
        return this.markTimedOutOrDeletedTaskName;
    }

    @Override
    public int getMarkTimedOutOrDeletedTaskInterval() {
        this.init();
        return this.markTimedOutOrDeletedTaskInterval;
    }

    @Override
    public String getCacheClearanceTaskName() {
        this.init();
        return this.cacheClearanceTaskName;
    }

    @Override
    public int getCacheClearanceTaskInterval() {
        this.init();
        return this.cacheClearanceTaskInterval;
    }

    private static int getAvailabilityTimeOrDefault(Integer availabilityTimeOrNull, int availabilityTimeDefault, int availabilityTimeMax) {
        if (availabilityTimeOrNull == null) {
            return availabilityTimeDefault;
        }
        return Math.min(availabilityTimeMax, Math.max(0, availabilityTimeOrNull));
    }

    private static String getStringPropertyOrDefault(Properties properties, String propertyName, String defaultValue) {
        String value = properties.getProperty(propertyName);
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        return value.trim();
    }

    private static Integer getIntegerPropertyOrDefault(Properties properties, String propertyName, Integer defaultValue) {
        String stringValue = OperationExecutionConfig.getStringPropertyOrDefault(properties, propertyName, String.valueOf(defaultValue));
        if (NumberUtils.isNumber((String)stringValue)) {
            return NumberUtils.createNumber((String)stringValue).intValue();
        }
        return null;
    }

    private static void checkPositiveProperty(Properties properties, String propertyName, Integer propertyValue) {
        if (propertyValue <= 0) {
            throw new IllegalArgumentException(String.format("Property '%s' value must be > 0 but was '%s'", propertyName, propertyValue));
        }
    }

    private static void checkPositiveOrZeroProperty(Properties properties, String propertyName, Integer propertyValue) {
        if (propertyValue < 0) {
            throw new IllegalArgumentException(String.format("Property '%s' value must be >= 0 but was '%s'", propertyName, propertyValue));
        }
    }

    private static void checkGreaterThanOrEqualToOtherProperty(Properties properties, String propertyName, Integer propertyValue, String otherPropertyName, Integer otherPropertyValue) {
        if (propertyValue < otherPropertyValue) {
            throw new IllegalArgumentException(String.format("Property '%s' value must be >= %s (property '%s' value) but was '%s'", propertyName, otherPropertyValue, otherPropertyName, propertyValue));
        }
    }

    protected Properties getProperties() {
        return this.configurer.getResolvedProps();
    }
}

