/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.delete;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecution;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionAvailability;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.delete.OperationExecutionDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.fetchoptions.OperationExecutionFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.id.IOperationExecutionId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.id.OperationExecutionPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.IOperationExecutionAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.delete.IDeleteOperationExecutionExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.IOperationExecutionStore;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionPE;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteOperationExecutionExecutor
extends AbstractDeleteEntityExecutor<Void, IOperationExecutionId, OperationExecutionPE, OperationExecutionDeletionOptions>
implements IDeleteOperationExecutionExecutor {
    @Autowired
    private IOperationExecutionAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IOperationExecutionStore executionStore;

    @Override
    protected Map<IOperationExecutionId, OperationExecutionPE> map(IOperationContext context, List<? extends IOperationExecutionId> ids, OperationExecutionDeletionOptions deletionOptions) {
        LinkedHashMap<IOperationExecutionId, OperationExecutionPE> map = new LinkedHashMap<IOperationExecutionId, OperationExecutionPE>();
        for (IOperationExecutionId iOperationExecutionId : ids) {
            OperationExecutionPE executionPE;
            OperationExecution execution = this.executionStore.getExecution(context, iOperationExecutionId, new OperationExecutionFetchOptions());
            if (execution == null || (executionPE = this.daoFactory.getOperationExecutionDAO().tryFindByCode(execution.getCode())) == null) continue;
            map.put(iOperationExecutionId, executionPE);
        }
        return map;
    }

    @Override
    protected void checkAccess(IOperationContext context, IOperationExecutionId entityId, OperationExecutionPE entity) {
        try {
            this.authorizationExecutor.canDelete(context, entityId, entity);
        }
        catch (AuthorizationFailureException ex) {
            throw new UnauthorizedObjectAccessException((IObjectId)entityId);
        }
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, OperationExecutionPE entity) {
    }

    @Override
    protected Void delete(IOperationContext context, Collection<OperationExecutionPE> executions, OperationExecutionDeletionOptions deletionOptions) {
        for (OperationExecutionPE execution : executions) {
            this.executionStore.executionAvailability(context, new OperationExecutionPermId(execution.getCode()), OperationExecutionAvailability.DELETE_PENDING);
        }
        return null;
    }
}

