/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.internal;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.internal.IInternalOperation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.internal.IInternalOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.ConcurrentOperation;
import ch.systemsx.cisd.openbis.generic.server.IConcurrentOperationLimiter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InternalOperationExecutor
implements IInternalOperationExecutor {
    @Autowired
    private IConcurrentOperationLimiter operationLimiter;

    @Override
    public Map<IOperation, IOperationResult> execute(IOperationContext context, List<? extends IOperation> operations) {
        boolean isInstanceAdmin = this.isInstanceAdmin(context);
        HashMap<IOperation, IOperationResult> results = new HashMap<IOperation, IOperationResult>();
        for (final IOperation iOperation : operations) {
            if (!(iOperation instanceof IInternalOperation) || !isInstanceAdmin) continue;
            Object result = null;
            if (context.isAsync()) {
                this.operationLimiter.executeLimitedWithTimeoutAsync(iOperation.getClass().getSimpleName(), new ConcurrentOperation<IOperationResult>(){

                    @Override
                    public IOperationResult execute() {
                        return ((IInternalOperation)iOperation).execute();
                    }
                });
            } else {
                this.operationLimiter.executeLimitedWithTimeout(iOperation.getClass().getSimpleName(), new ConcurrentOperation<IOperationResult>(){

                    @Override
                    public IOperationResult execute() {
                        return ((IInternalOperation)iOperation).execute();
                    }
                });
            }
            results.put(iOperation, (IOperationResult)result);
        }
        return results;
    }

    private boolean isInstanceAdmin(IOperationContext context) {
        Set<RoleAssignmentPE> roles = context.getSession() != null && context.getSession().tryGetPerson() != null ? context.getSession().tryGetPerson().getAllPersonRoles() : Collections.emptySet();
        for (RoleAssignmentPE role : roles) {
            if (!RoleWithHierarchy.RoleCode.ADMIN.equals((Object)role.getRole()) || !role.getRoleWithHierarchy().isInstanceLevel()) continue;
            return true;
        }
        return false;
    }
}

