/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.notification;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionEmailNotification;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.notification.IOperationExecutionEmailNotifier;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.mail.MailClientParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class OperationExecutionEmailNotifier
implements IOperationExecutionEmailNotifier {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, OperationExecutionEmailNotifier.class);
    @Resource(name="mail-client-parameters")
    private MailClientParameters mailClientParameters;
    private IMailClient mailClient;

    public OperationExecutionEmailNotifier() {
    }

    OperationExecutionEmailNotifier(IMailClient mailClient) {
        this.mailClient = mailClient;
    }

    @PostConstruct
    private void init() {
        this.mailClient = new MailClient(this.mailClientParameters);
    }

    @Override
    public void executionFinished(String code, String description, List<String> operations, List<String> results, OperationExecutionEmailNotification notification) {
        Object[] emailAddresses = this.getEmailAddresses(notification);
        if (emailAddresses.length > 0) {
            StringBuilder content = new StringBuilder();
            this.appendCodeAndDescription(content, code, description);
            this.appendOperationsAndResults(content, operations, results, true, true);
            this.mailClient.sendEmailMessage("Operation execution " + code + " finished", content.toString(), null, null, (EMailAddress[])emailAddresses);
            operationLog.info((Object)("Send an email to " + Arrays.toString(emailAddresses) + " to notify that execution " + code + " finised"));
        }
    }

    @Override
    public void executionFailed(String code, String description, List<String> operations, String error, OperationExecutionEmailNotification notification) {
        Object[] emailAddresses = this.getEmailAddresses(notification);
        if (emailAddresses.length > 0) {
            StringBuilder content = new StringBuilder();
            this.appendCodeAndDescription(content, code, description);
            this.appendOperationsAndResults(content, operations, null, true, false);
            this.appendError(content, error);
            this.mailClient.sendEmailMessage("Operation execution " + code + " failed", content.toString(), null, null, (EMailAddress[])emailAddresses);
            operationLog.info((Object)("Send an email to " + Arrays.toString(emailAddresses) + " to notify that execution " + code + " failed"));
        }
    }

    private EMailAddress[] getEmailAddresses(OperationExecutionEmailNotification notification) {
        ArrayList<EMailAddress> emailAddresses = new ArrayList<EMailAddress>();
        if (notification.getEmails() != null) {
            for (String email : notification.getEmails()) {
                if (email == null || email.trim().isEmpty()) continue;
                emailAddresses.add(new EMailAddress(email));
            }
        }
        return emailAddresses.toArray(new EMailAddress[0]);
    }

    private void appendCodeAndDescription(StringBuilder content, String code, String description) {
        content.append("Execution: " + code);
        if (description != null && description.trim().length() > 0) {
            content.append("\nDescription: " + description);
        }
    }

    private void appendOperationsAndResults(StringBuilder content, List<String> operations, List<String> results, boolean appendOperations, boolean appendResults) {
        List<String> notNullOperations = operations != null ? operations : Collections.singletonList(null);
        List<String> notNullResults = results != null ? results : Collections.singletonList(null);
        Iterator<String> iterOperations = notNullOperations.iterator();
        Iterator<String> iterResults = notNullResults.iterator();
        boolean manyOperationsOrResults = notNullOperations.size() > 1 || notNullResults.size() > 1;
        int index = 0;
        if (manyOperationsOrResults) {
            content.append("\n");
        }
        while (iterOperations.hasNext() || iterResults.hasNext()) {
            String result;
            String operation = iterOperations.hasNext() ? iterOperations.next() : null;
            String string = result = iterResults.hasNext() ? iterResults.next() : null;
            if (appendOperations) {
                content.append("\nOperation");
                if (manyOperationsOrResults) {
                    content.append(" " + (index + 1));
                }
                content.append(": " + operation);
            }
            if (appendResults) {
                content.append("\nResult");
                if (manyOperationsOrResults) {
                    content.append(" " + (index + 1));
                }
                content.append(": " + result);
            }
            if (appendOperations && appendResults && (iterOperations.hasNext() || iterResults.hasNext())) {
                content.append("\n");
            }
            ++index;
        }
        if (manyOperationsOrResults) {
            content.append("\n");
        }
    }

    private void appendError(StringBuilder content, String error) {
        content.append("\nError: " + error);
    }
}

