/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.notification;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.IOperationExecutionNotification;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionEmailNotification;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.notification.IOperationExecutionEmailNotifier;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.notification.IOperationExecutionNotifier;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperationExecutionNotifier
implements IOperationExecutionNotifier {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, OperationExecutionNotifier.class);
    @Autowired
    private IOperationExecutionEmailNotifier emailNotifier;

    public OperationExecutionNotifier() {
    }

    OperationExecutionNotifier(IOperationExecutionEmailNotifier emailNotifier) {
        this.emailNotifier = emailNotifier;
    }

    @Override
    public void executionNew(String code, IOperationExecutionNotification notification) {
        if (notification == null) {
            return;
        }
        if (!(notification instanceof OperationExecutionEmailNotification)) {
            throw new UnsupportedNotificationException(code, notification);
        }
    }

    @Override
    public void executionFinished(String code, String description, List<String> operations, List<String> results, IOperationExecutionNotification notification) {
        if (notification == null) {
            return;
        }
        try {
            if (!(notification instanceof OperationExecutionEmailNotification)) {
                throw new UnsupportedNotificationException(code, notification);
            }
            this.emailNotifier.executionFinished(code, description, operations, results, (OperationExecutionEmailNotification)notification);
        }
        catch (Exception e) {
            operationLog.warn((Object)"Couldn't notify about a finished execution", (Throwable)e);
        }
    }

    @Override
    public void executionFailed(String code, String description, List<String> operations, String error, IOperationExecutionNotification notification) {
        if (notification == null) {
            return;
        }
        try {
            if (!(notification instanceof OperationExecutionEmailNotification)) {
                throw new UnsupportedNotificationException(code, notification);
            }
            this.emailNotifier.executionFailed(code, description, operations, error, (OperationExecutionEmailNotification)notification);
        }
        catch (Exception e) {
            operationLog.warn((Object)"Couldn't notify about a failed execution", (Throwable)e);
        }
    }

    private class UnsupportedNotificationException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public UnsupportedNotificationException(String code, IOperationExecutionNotification notification) {
            super("Unsupported notification " + notification.getClass().getName() + " found for operation execution with id " + code);
        }
    }
}

