/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.IOperationExecutionDBStore;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.IOperationExecutionDBStoreDAO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionAvailability;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionState;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class OperationExecutionDBStore
implements IOperationExecutionDBStore {
    @Autowired
    private IOperationExecutionDBStoreDAO dao;

    public OperationExecutionDBStore() {
    }

    OperationExecutionDBStore(IOperationExecutionDBStoreDAO dao) {
        this.dao = dao;
    }

    @Override
    public void executionNew(String code, Long owner, String description, String notification, List<String> operations, long availabilityTime, long summaryAvailabilityTime, long detailsAvailabilityTime, String detailsPath) {
        OperationExecutionPE executionPE = new OperationExecutionPE();
        executionPE.setCode(code);
        executionPE.setState(OperationExecutionState.NEW);
        executionPE.setOwner(this.dao.findPersonById(owner));
        executionPE.setNotification(notification);
        executionPE.setDescription(description);
        executionPE.setAvailability(this.initialAvailability(availabilityTime));
        executionPE.setAvailabilityTime(availabilityTime);
        executionPE.setCreationDate(new Date());
        executionPE.setSummaryOperationsList(operations);
        executionPE.setSummaryAvailability(this.initialAvailability(summaryAvailabilityTime));
        executionPE.setSummaryAvailabilityTime(summaryAvailabilityTime);
        executionPE.setDetailsAvailability(this.initialAvailability(detailsAvailabilityTime));
        executionPE.setDetailsAvailabilityTime(detailsAvailabilityTime);
        executionPE.setDetailsPath(detailsPath);
        try {
            this.dao.createExecution(executionPE);
        }
        catch (DataAccessException e) {
            DataAccessExceptionTranslator.throwException(e, "Operation execution " + code, null);
        }
    }

    @Override
    public void executionScheduled(String code) {
        OperationExecutionPE executionPE = this.dao.findExecutionByCode(code);
        executionPE.setState(OperationExecutionState.SCHEDULED);
    }

    @Override
    public void executionRunning(String code) {
        OperationExecutionPE executionPE = this.dao.findExecutionByCode(code);
        executionPE.setState(OperationExecutionState.RUNNING);
        executionPE.setStartDate(new Date());
    }

    @Override
    public void executionProgressed(String code, String progress) {
        this.dao.updateExecutionProgress(code, progress);
    }

    @Override
    public void executionFailed(String code, String error) {
        OperationExecutionPE executionPE = this.dao.findExecutionByCode(code);
        executionPE.setState(OperationExecutionState.FAILED);
        executionPE.setSummaryError(error);
        executionPE.setFinishDate(new Date());
    }

    @Override
    public void executionFinished(String code, List<String> results) {
        OperationExecutionPE executionPE = this.dao.findExecutionByCode(code);
        executionPE.setState(OperationExecutionState.FINISHED);
        executionPE.setSummaryProgress(null);
        executionPE.setSummaryResultsList(results);
        executionPE.setFinishDate(new Date());
    }

    @Override
    public void executionAvailability(String code, OperationExecutionAvailability availability) {
        OperationExecutionPE executionPE = this.dao.findExecutionByCode(code);
        if (executionPE != null) {
            if (OperationExecutionAvailability.TIMED_OUT.equals(availability) || OperationExecutionAvailability.DELETED.equals(availability)) {
                try {
                    this.dao.deleteExecution(executionPE);
                }
                catch (DataAccessException e) {
                    DataAccessExceptionTranslator.throwException(e, "Operation execution " + code, null);
                }
            } else {
                executionPE.setAvailability(availability);
            }
        }
    }

    @Override
    public void executionSummaryAvailability(String code, OperationExecutionAvailability summaryAvailability) {
        OperationExecutionPE executionPE = this.dao.findExecutionByCode(code);
        if (executionPE != null) {
            executionPE.setSummaryAvailability(summaryAvailability);
            if (OperationExecutionAvailability.TIMED_OUT.equals(summaryAvailability) || OperationExecutionAvailability.DELETED.equals(summaryAvailability)) {
                executionPE.setSummaryOperations(null);
                executionPE.setSummaryProgress(null);
                executionPE.setSummaryError(null);
                executionPE.setSummaryResults(null);
            }
        }
    }

    @Override
    public void executionDetailsAvailability(String code, OperationExecutionAvailability detailsAvailability) {
        OperationExecutionPE executionPE = this.dao.findExecutionByCode(code);
        if (executionPE != null) {
            executionPE.setDetailsAvailability(detailsAvailability);
            if (OperationExecutionAvailability.TIMED_OUT.equals(detailsAvailability) || OperationExecutionAvailability.DELETED.equals(detailsAvailability)) {
                executionPE.setDetailsPath(null);
            }
        }
    }

    @Override
    public OperationExecutionPE getExecution(String code) {
        return this.dao.findExecutionByCode(code);
    }

    @Override
    public List<OperationExecutionPE> getExecutions() {
        return this.dao.findAllExecutions();
    }

    @Override
    public List<OperationExecutionPE> getExecutionsToBeFailedAfterServerRestart(Date serverStartDate) {
        return this.dao.findExecutionsToBeFailedAfterServerRestart(serverStartDate);
    }

    @Override
    public List<OperationExecutionPE> getExecutionsToBeTimeOutPending() {
        return this.dao.findExecutionsToBeTimeOutPending();
    }

    @Override
    public List<OperationExecutionPE> getExecutionsToBeTimedOut() {
        return this.dao.findExecutionsToBeTimedOut();
    }

    @Override
    public List<OperationExecutionPE> getExecutionsToBeDeleted() {
        return this.dao.findExecutionsToBeDeleted();
    }

    private OperationExecutionAvailability initialAvailability(Long availabilityTime) {
        return availabilityTime != null && availabilityTime > 0L ? OperationExecutionAvailability.AVAILABLE : OperationExecutionAvailability.TIME_OUT_PENDING;
    }
}

