/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.IOperationExecutionDBStoreDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionState;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperationExecutionDBStoreDAO
implements IOperationExecutionDBStoreDAO {
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    public PersonPE findPersonById(Long personId) {
        return (PersonPE)this.daoFactory.getSessionFactory().getCurrentSession().load(PersonPE.class, (Serializable)personId);
    }

    @Override
    public OperationExecutionPE findExecutionByCode(String code) {
        return this.refresh(this.daoFactory.getOperationExecutionDAO().tryFindByCode(code));
    }

    @Override
    public void createExecution(OperationExecutionPE executionPE) {
        this.daoFactory.getOperationExecutionDAO().createOrUpdate(executionPE);
    }

    @Override
    public void updateExecutionProgress(String code, String progress) {
        Query query = this.daoFactory.getSessionFactory().getCurrentSession().createQuery("update OperationExecutionPE set summaryProgress = :progress where code = :code and state in (:states) and summaryAvailability = 'AVAILABLE'");
        query.setParameter("code", (Object)code);
        query.setParameter("progress", (Object)progress);
        query.setParameterList("states", Arrays.asList(OperationExecutionState.RUNNING, OperationExecutionState.FAILED, OperationExecutionState.FINISHED));
        query.executeUpdate();
    }

    @Override
    public void deleteExecution(OperationExecutionPE executionPE) {
        this.daoFactory.getOperationExecutionDAO().delete(executionPE);
    }

    @Override
    public List<OperationExecutionPE> findAllExecutions() {
        return this.refresh(this.daoFactory.getOperationExecutionDAO().listAllEntities());
    }

    @Override
    public List<OperationExecutionPE> findExecutionsToBeFailedAfterServerRestart(Date serverStartDate) {
        return this.refresh(this.daoFactory.getOperationExecutionDAO().getExecutionsToBeFailedAfterServerRestart(serverStartDate));
    }

    @Override
    public List<OperationExecutionPE> findExecutionsToBeTimeOutPending() {
        return this.refresh(this.daoFactory.getOperationExecutionDAO().getExecutionsToBeTimeOutPending());
    }

    @Override
    public List<OperationExecutionPE> findExecutionsToBeTimedOut() {
        return this.refresh(this.daoFactory.getOperationExecutionDAO().getExecutionsToBeTimedOut());
    }

    @Override
    public List<OperationExecutionPE> findExecutionsToBeDeleted() {
        return this.refresh(this.daoFactory.getOperationExecutionDAO().getExecutionsToBeDeleted());
    }

    private OperationExecutionPE refresh(OperationExecutionPE execution) {
        if (execution != null) {
            this.daoFactory.getSessionFactory().getCurrentSession().refresh((Object)execution);
        }
        return execution;
    }

    private List<OperationExecutionPE> refresh(List<OperationExecutionPE> executions) {
        if (executions != null) {
            for (OperationExecutionPE execution : executions) {
                this.refresh(execution);
            }
        }
        return executions;
    }
}

