/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store;

import ch.systemsx.cisd.common.security.MD5ChecksumCalculator;
import java.io.File;

public class OperationExecutionDirectory {
    private String executionStorePath;
    private String executionCode;

    public OperationExecutionDirectory(String executionStorePath, String executionCode) {
        this.executionStorePath = executionStorePath;
        this.executionCode = executionCode;
    }

    public File getFile() {
        File storeDir = new File(this.executionStorePath);
        String checksum = MD5ChecksumCalculator.calculate((String)this.executionCode);
        File dirLevel1 = new File(storeDir, checksum.substring(0, 2));
        File dirLevel2 = new File(dirLevel1, checksum.substring(2, 4));
        File dirLevel3 = new File(dirLevel2, checksum.substring(4, 6));
        File executionDir = new File(dirLevel3, this.executionCode);
        return executionDir;
    }

    public String getRelativePath() {
        File storeDir = new File(this.executionStorePath);
        File executionDir = this.getFile();
        String relativePath = executionDir.getAbsolutePath().substring(storeDir.getAbsolutePath().length());
        if (relativePath.startsWith(File.separator)) {
            return relativePath.substring(File.separator.length());
        }
        return relativePath;
    }
}

