/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationExecutionError;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationExecutionProgress;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionAvailability;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.config.IOperationExecutionConfig;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.IOperationExecutionFSStore;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.OperationExecutionDirectory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.OperationExecutionFS;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.OperationExecutionFSFetchOptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperationExecutionFSStore
implements IOperationExecutionFSStore {
    public static final String OPERATIONS_FILE_NAME = "operations";
    public static final String PROGRESS_FILE_NAME = "progress";
    public static final String ERROR_FILE_NAME = "error";
    public static final String RESULTS_FILE_NAME = "results";
    @Autowired
    private IOperationExecutionConfig config;

    public OperationExecutionFSStore() {
    }

    OperationExecutionFSStore(IOperationExecutionConfig config) {
        this.config = config;
    }

    @Override
    public void executionNew(String code, List<? extends IOperation> operations) {
        File dir = this.getExecutionDirectory(code).getFile();
        dir.mkdirs();
        File file = new File(dir, OPERATIONS_FILE_NAME);
        this.writeToFile(file, operations, true);
    }

    @Override
    public void executionProgressed(String code, OperationExecutionProgress progress) {
        File dir = this.getExecutionDirectory(code).getFile();
        File file = new File(dir, PROGRESS_FILE_NAME);
        this.writeToFile(file, progress, false);
    }

    @Override
    public void executionFailed(String code, IOperationExecutionError error) {
        File dir = this.getExecutionDirectory(code).getFile();
        File file = new File(dir, ERROR_FILE_NAME);
        this.writeToFile(file, error, true);
    }

    @Override
    public void executionFinished(String code, List<? extends IOperationResult> results) {
        File dir = this.getExecutionDirectory(code).getFile();
        File file = new File(dir, RESULTS_FILE_NAME);
        this.writeToFile(file, results, true);
    }

    @Override
    public void executionAvailability(String code, OperationExecutionAvailability availability) {
        File dir;
        if ((OperationExecutionAvailability.DELETED.equals((Object)availability) || OperationExecutionAvailability.TIMED_OUT.equals((Object)availability)) && (dir = this.getExecutionDirectory(code).getFile()).exists()) {
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void executionSummaryAvailability(String code, OperationExecutionAvailability summaryAvailability) {
    }

    @Override
    public void executionDetailsAvailability(String code, OperationExecutionAvailability detailsAvailability) {
        this.executionAvailability(code, detailsAvailability);
    }

    @Override
    public OperationExecutionFS getExecution(String code, OperationExecutionFSFetchOptions fo) {
        File file;
        OperationExecutionFS execution = new OperationExecutionFS();
        OperationExecutionDirectory executionDir = this.getExecutionDirectory(code);
        execution.setRelativePath(executionDir.getRelativePath());
        if (fo.hasOperations()) {
            file = new File(executionDir.getFile(), OPERATIONS_FILE_NAME);
            execution.setOperations((List)this.readFromFile(file, false));
        }
        if (fo.hasProgress()) {
            file = new File(executionDir.getFile(), PROGRESS_FILE_NAME);
            execution.setProgress((IOperationExecutionProgress)this.readFromFile(file, false));
        }
        if (fo.hasError()) {
            file = new File(executionDir.getFile(), ERROR_FILE_NAME);
            execution.setError((IOperationExecutionError)this.readFromFile(file, false));
        }
        if (fo.hasResults()) {
            file = new File(executionDir.getFile(), RESULTS_FILE_NAME);
            execution.setResults((List)this.readFromFile(file, false));
        }
        return execution;
    }

    private OperationExecutionDirectory getExecutionDirectory(String code) {
        return new OperationExecutionDirectory(this.config.getStorePath(), code);
    }

    private void writeToFile(File file, Object object, boolean failOnFileNotFound) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            out.writeObject(object);
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException && !failOnFileNotFound) {
                return;
            }
            throw new RuntimeException("Couldn't write operation execution details to file " + file.getAbsolutePath(), e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Object readFromFile(File file, boolean failOnFileNotFound) {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Object object = in.readObject();
            return object;
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException && !failOnFileNotFound) {
                Object var5_7 = null;
                return var5_7;
            }
            throw new RuntimeException("Couldn't read operation execution details from file " + file.getAbsolutePath(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

