/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationExecutionError;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationExecutionProgress;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.IOperationExecutionNotification;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.IOperationExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecution;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionAvailability;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionDetails;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionProgress;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionSummary;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.fetchoptions.OperationExecutionDetailsFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.fetchoptions.OperationExecutionFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.fetchoptions.OperationExecutionSummaryFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.id.IOperationExecutionId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.id.OperationExecutionPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnsupportedObjectIdException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgressListener;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgressStack;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.ProgressFormatter;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.IOperationExecutionAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.config.IOperationExecutionConfig;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.notification.IOperationExecutionNotifier;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.IOperationExecutionDBStore;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.IOperationExecutionFSStore;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.IOperationExecutionStore;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.OperationExecutionFS;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.store.OperationExecutionFSFetchOptions;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionState;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class OperationExecutionStore
implements IOperationExecutionStore,
ApplicationContextAware {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, OperationExecutionStore.class);
    private ApplicationContext applicationContext;
    @Resource(name="objectMapper-v3")
    private ObjectMapper objectMapper;
    @Autowired
    private IOperationExecutionConfig config;
    @Autowired
    private IOperationExecutionAuthorizationExecutor authorization;
    @Autowired
    private IOperationExecutionDBStore dbStore;
    @Autowired
    private IOperationExecutionFSStore fsStore;
    @Autowired
    private IOperationExecutionNotifier notifier;
    private Thread progressThread;
    private Map<OperationExecutionPermId, IProgress> progressMap = new HashMap<OperationExecutionPermId, IProgress>();

    public OperationExecutionStore() {
    }

    OperationExecutionStore(IOperationExecutionConfig config, IOperationExecutionAuthorizationExecutor authorization, IOperationExecutionDBStore dbStore, IOperationExecutionFSStore fsStore, IOperationExecutionNotifier notifier) {
        this.config = config;
        this.authorization = authorization;
        this.dbStore = dbStore;
        this.fsStore = fsStore;
        this.notifier = notifier;
    }

    @PostConstruct
    void init() {
        this.progressThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    if (!OperationExecutionStore.this.progressMap.isEmpty()) {
                        IOperationExecutionStore store = (IOperationExecutionStore)OperationExecutionStore.this.applicationContext.getBean(IOperationExecutionStore.class);
                        store.synchronizeProgress();
                    }
                    try {
                        Thread.sleep(OperationExecutionStore.this.config.getProgressInterval() * 1000);
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                }
            }
        });
        this.progressThread.setName(this.config.getProgressThreadName());
        this.progressThread.setDaemon(true);
        this.progressThread.start();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void executionNew(IOperationContext context, final OperationExecutionPermId executionId, List<? extends IOperation> operations, IOperationExecutionOptions options) {
        this.checkContext(context);
        this.checkExecutionId((IOperationExecutionId)executionId);
        this.checkOperations(operations);
        this.checkOptions(options);
        context.addProgressListener(new IProgressListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProgress(IProgressStack progressStack) {
                IProgress progress;
                if (progressStack.size() > 0 && (progress = progressStack.iterator().next()) != null) {
                    Map map = OperationExecutionStore.this.progressMap;
                    synchronized (map) {
                        OperationExecutionStore.this.progressMap.put(executionId, progress);
                    }
                }
            }
        });
        ArrayList<String> operationsMessages = new ArrayList<String>();
        for (IOperation iOperation : operations) {
            operationsMessages.add(iOperation.getMessage());
        }
        int availabilityTime = this.config.getAvailabilityTimeOrDefault(options.getAvailabilityTime());
        int n = this.config.getSummaryAvailabilityTimeOrDefault(options.getSummaryAvailabilityTime());
        int detailsAvailabilityTime = this.config.getDetailsAvailabilityTimeOrDefault(options.getDetailsAvailabilityTime());
        OperationExecutionFS executionFS = this.fsStore.getExecution(executionId.getPermId(), new OperationExecutionFSFetchOptions());
        this.dbStore.executionNew(executionId.getPermId(), context.getSession().tryGetPerson().getId(), options.getDescription(), this.translateNotification((IOperationExecutionId)executionId, options.getNotification()), operationsMessages, availabilityTime, n, detailsAvailabilityTime, executionFS.getRelativePath());
        this.fsStore.executionNew(executionId.getPermId(), operations);
        this.notifier.executionNew(executionId.getPermId(), options.getNotification());
        operationLog.info((Object)("Execution " + executionId + " is new"));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void executionScheduled(IOperationContext context, OperationExecutionPermId executionId) {
        this.checkContext(context);
        this.checkExecutionId((IOperationExecutionId)executionId);
        OperationExecutionPE execution = this.dbStore.getExecution(executionId.getPermId());
        this.checkExecution((IOperationExecutionId)executionId, execution);
        this.checkAccess(context, execution);
        this.dbStore.executionScheduled(executionId.getPermId());
        operationLog.info((Object)("Execution " + executionId + " has been scheduled"));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void executionRunning(IOperationContext context, OperationExecutionPermId executionId) {
        this.checkContext(context);
        this.checkExecutionId((IOperationExecutionId)executionId);
        OperationExecutionPE execution = this.dbStore.getExecution(executionId.getPermId());
        this.checkExecution((IOperationExecutionId)executionId, execution);
        this.checkAccess(context, execution);
        this.dbStore.executionRunning(executionId.getPermId());
        operationLog.info((Object)("Execution " + executionId + " is running"));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void executionFailed(IOperationContext context, OperationExecutionPermId executionId, IOperationExecutionError error) {
        this.checkContext(context);
        this.checkExecutionId((IOperationExecutionId)executionId);
        this.checkError(error);
        OperationExecutionPE execution = this.dbStore.getExecution(executionId.getPermId());
        this.checkExecution((IOperationExecutionId)executionId, execution);
        this.checkAccess(context, execution);
        this.dbStore.executionFailed(executionId.getPermId(), error.getMessage());
        this.fsStore.executionFailed(executionId.getPermId(), error);
        this.notifier.executionFailed(executionId.getPermId(), execution.getDescription(), execution.getSummaryOperationsList(), error.getMessage(), this.translateNotification((IOperationExecutionId)executionId, execution.getNotification()));
        operationLog.error((Object)("Execution " + executionId + " has failed"));
        operationLog.error((Object)error.getMessage());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void executionFinished(IOperationContext context, OperationExecutionPermId executionId, List<? extends IOperationResult> results) {
        this.checkContext(context);
        this.checkExecutionId((IOperationExecutionId)executionId);
        this.checkResults(results);
        OperationExecutionPE execution = this.dbStore.getExecution(executionId.getPermId());
        this.checkExecution((IOperationExecutionId)executionId, execution);
        this.checkAccess(context, execution);
        ArrayList<String> resultsMessages = new ArrayList<String>();
        for (IOperationResult iOperationResult : results) {
            resultsMessages.add(iOperationResult.getMessage());
        }
        this.dbStore.executionFinished(executionId.getPermId(), resultsMessages);
        this.fsStore.executionFinished(executionId.getPermId(), results);
        this.notifier.executionFinished(executionId.getPermId(), execution.getDescription(), execution.getSummaryOperationsList(), resultsMessages, this.translateNotification((IOperationExecutionId)executionId, execution.getNotification()));
        operationLog.info((Object)("Execution " + executionId + " has finished"));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void executionAvailability(IOperationContext context, OperationExecutionPermId executionId, OperationExecutionAvailability availability) {
        this.checkContext(context);
        this.checkExecutionId((IOperationExecutionId)executionId);
        OperationExecutionPE execution = this.dbStore.getExecution(executionId.getPermId());
        this.checkAvailability(executionId, execution.getAvailability(), availability);
        this.checkExecution((IOperationExecutionId)executionId, execution);
        this.checkAccess(context, execution);
        this.dbStore.executionAvailability(executionId.getPermId(), this.convertAvailability(availability));
        this.fsStore.executionAvailability(executionId.getPermId(), availability);
        operationLog.info((Object)("Execution " + executionId + " availability has changed to " + availability));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void executionSummaryAvailability(IOperationContext context, OperationExecutionPermId executionId, OperationExecutionAvailability summaryAvailability) {
        this.checkContext(context);
        this.checkExecutionId((IOperationExecutionId)executionId);
        OperationExecutionPE execution = this.dbStore.getExecution(executionId.getPermId());
        this.checkAvailability(executionId, execution.getSummaryAvailability(), summaryAvailability);
        this.checkExecution((IOperationExecutionId)executionId, execution);
        this.checkAccess(context, execution);
        this.dbStore.executionSummaryAvailability(executionId.getPermId(), this.convertAvailability(summaryAvailability));
        this.fsStore.executionSummaryAvailability(executionId.getPermId(), summaryAvailability);
        operationLog.info((Object)("Execution " + executionId + " summary availability has changed to " + summaryAvailability));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void executionDetailsAvailability(IOperationContext context, OperationExecutionPermId executionId, OperationExecutionAvailability detailsAvailability) {
        this.checkContext(context);
        this.checkExecutionId((IOperationExecutionId)executionId);
        OperationExecutionPE execution = this.dbStore.getExecution(executionId.getPermId());
        this.checkAvailability(executionId, execution.getDetailsAvailability(), detailsAvailability);
        this.checkExecution((IOperationExecutionId)executionId, execution);
        this.checkAccess(context, execution);
        this.dbStore.executionDetailsAvailability(executionId.getPermId(), this.convertAvailability(detailsAvailability));
        this.fsStore.executionDetailsAvailability(executionId.getPermId(), detailsAvailability);
        operationLog.info((Object)("Execution " + executionId + " details availability has changed to " + detailsAvailability));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void synchronizeProgress() {
        HashMap<OperationExecutionPermId, IProgress> progressMapCopy = new HashMap<OperationExecutionPermId, IProgress>();
        Map<OperationExecutionPermId, IProgress> map = this.progressMap;
        synchronized (map) {
            progressMapCopy.putAll(this.progressMap);
            this.progressMap.clear();
        }
        if (!progressMapCopy.isEmpty()) {
            operationLog.info((Object)("Progress synchronization with database and file system has been started (" + progressMapCopy.size() + " execution(s) to be synchronized)."));
            int successCount = 0;
            int failureCount = 0;
            for (Map.Entry progressEntry : progressMapCopy.entrySet()) {
                OperationExecutionPermId executionId = (OperationExecutionPermId)progressEntry.getKey();
                IProgress progress = (IProgress)progressEntry.getValue();
                try {
                    this.dbStore.executionProgressed(executionId.getPermId(), ProgressFormatter.format(progress));
                    this.fsStore.executionProgressed(executionId.getPermId(), new OperationExecutionProgress(ProgressFormatter.format(progress), progress.getNumItemsProcessed(), progress.getTotalItemsToProcess()));
                    operationLog.info((Object)("Execution " + executionId + " progressed (" + ProgressFormatter.formatShort(progress) + ")"));
                    ++successCount;
                }
                catch (Throwable t) {
                    operationLog.error((Object)("Couldn't synchronize progress for execution with id " + executionId), t);
                    ++failureCount;
                }
            }
            operationLog.info((Object)("Progress synchronization with database and file system has been finished (" + successCount + " execution(s) has been successfully synchronized, synchronization of " + failureCount + " execution(s) has failed)."));
        }
    }

    @Override
    @Transactional
    public OperationExecution getExecution(IOperationContext context, IOperationExecutionId executionId, OperationExecutionFetchOptions fo) {
        this.checkContext(context);
        this.checkExecutionId(executionId);
        OperationExecutionPE executionPE = this.dbStore.getExecution(((OperationExecutionPermId)executionId).getPermId());
        if (executionPE != null) {
            this.checkAccess(context, executionPE);
            return this.translate(context, executionPE, fo);
        }
        return null;
    }

    @Override
    @Transactional
    public List<OperationExecution> getExecutions(IOperationContext context, OperationExecutionFetchOptions fetchOptions) {
        this.checkContext(context);
        this.checkAccess(context);
        List<OperationExecutionPE> executionPEs = this.dbStore.getExecutions();
        return this.translate(context, this.filter(context, executionPEs), fetchOptions);
    }

    @Override
    @Transactional
    public List<OperationExecution> getExecutionsToBeFailedAfterServerRestart(IOperationContext context, Date serverStartDate, OperationExecutionFetchOptions fetchOptions) {
        this.checkContext(context);
        this.checkAccess(context);
        List<OperationExecutionPE> executionPEs = this.dbStore.getExecutionsToBeFailedAfterServerRestart(serverStartDate);
        return this.translate(context, this.filter(context, executionPEs), fetchOptions);
    }

    @Override
    @Transactional
    public List<OperationExecution> getExecutionsToBeTimeOutPending(IOperationContext context, OperationExecutionFetchOptions fetchOptions) {
        this.checkContext(context);
        this.checkAccess(context);
        List<OperationExecutionPE> executionPEs = this.dbStore.getExecutionsToBeTimeOutPending();
        return this.translate(context, this.filter(context, executionPEs), fetchOptions);
    }

    @Override
    @Transactional
    public List<OperationExecution> getExecutionsToBeTimedOut(IOperationContext context, OperationExecutionFetchOptions fetchOptions) {
        this.checkContext(context);
        this.checkAccess(context);
        List<OperationExecutionPE> executionPEs = this.dbStore.getExecutionsToBeTimedOut();
        return this.translate(context, this.filter(context, executionPEs), fetchOptions);
    }

    @Override
    @Transactional
    public List<OperationExecution> getExecutionsToBeDeleted(IOperationContext context, OperationExecutionFetchOptions fetchOptions) {
        this.checkContext(context);
        this.checkAccess(context);
        List<OperationExecutionPE> executionPEs = this.dbStore.getExecutionsToBeDeleted();
        return this.translate(context, this.filter(context, executionPEs), fetchOptions);
    }

    private List<OperationExecutionPE> filter(IOperationContext context, Collection<OperationExecutionPE> executionPEs) {
        ArrayList<OperationExecutionPE> filtered = new ArrayList<OperationExecutionPE>();
        if (executionPEs != null) {
            for (OperationExecutionPE executionPE : executionPEs) {
                if (!this.authorization.canGet(context, executionPE)) continue;
                filtered.add(executionPE);
            }
        }
        return filtered;
    }

    private List<OperationExecution> translate(IOperationContext context, Collection<OperationExecutionPE> executionPEs, OperationExecutionFetchOptions fetchOptions) {
        ArrayList<OperationExecution> executions = new ArrayList<OperationExecution>();
        for (OperationExecutionPE executionPE : executionPEs) {
            OperationExecution execution = this.translate(context, executionPE, fetchOptions);
            if (execution == null) continue;
            executions.add(execution);
        }
        Collections.sort(executions, new Comparator<OperationExecution>(){

            @Override
            public int compare(OperationExecution o1, OperationExecution o2) {
                return o1.getCreationDate().compareTo(o2.getCreationDate());
            }
        });
        return executions;
    }

    private OperationExecution translate(IOperationContext context, OperationExecutionPE executionPE, OperationExecutionFetchOptions fetchOptions) {
        OperationExecutionPermId executionId = new OperationExecutionPermId(executionPE.getCode());
        OperationExecution execution = new OperationExecution();
        execution.setPermId(executionId);
        execution.setCode(executionPE.getCode());
        execution.setState(this.convertState(executionPE.getState()));
        execution.setDescription(executionPE.getDescription());
        execution.setNotification(this.translateNotification((IOperationExecutionId)executionId, executionPE.getNotification()));
        execution.setAvailability(this.convertAvailability(executionPE.getAvailability()));
        execution.setAvailabilityTime(Integer.valueOf(executionPE.getAvailabilityTime().intValue()));
        execution.setSummaryAvailability(this.convertAvailability(executionPE.getSummaryAvailability()));
        execution.setSummaryAvailabilityTime(Integer.valueOf(executionPE.getSummaryAvailabilityTime().intValue()));
        execution.setDetailsAvailability(this.convertAvailability(executionPE.getDetailsAvailability()));
        execution.setDetailsAvailabilityTime(Integer.valueOf(executionPE.getDetailsAvailabilityTime().intValue()));
        execution.setCreationDate(executionPE.getCreationDate());
        execution.setStartDate(executionPE.getStartDate());
        execution.setFinishDate(executionPE.getFinishDate());
        execution.setFetchOptions(fetchOptions);
        if (fetchOptions != null) {
            if (fetchOptions.hasSummary()) {
                OperationExecutionSummary summary = this.translateSummary(context, executionPE, fetchOptions.withSummary());
                execution.setSummary(summary);
            }
            if (fetchOptions.hasDetails()) {
                OperationExecutionDetails details = this.translateDetails(context, executionPE, fetchOptions.withDetails());
                execution.setDetails(details);
            }
        }
        return execution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationExecutionSummary translateSummary(IOperationContext context, OperationExecutionPE executionPE, OperationExecutionSummaryFetchOptions fetchOptions) {
        OperationExecutionAvailability summaryAvailability = this.convertAvailability(executionPE.getSummaryAvailability());
        if (OperationExecutionAvailability.TIMED_OUT.equals((Object)summaryAvailability) || OperationExecutionAvailability.DELETED.equals((Object)summaryAvailability)) {
            return null;
        }
        OperationExecutionSummary summary = new OperationExecutionSummary();
        summary.setFetchOptions(fetchOptions);
        if (fetchOptions.hasOperations()) {
            summary.setOperations(executionPE.getSummaryOperationsList());
        }
        if (fetchOptions.hasProgress()) {
            IProgress progress = null;
            Map<OperationExecutionPermId, IProgress> map = this.progressMap;
            synchronized (map) {
                progress = this.progressMap.get(new OperationExecutionPermId(executionPE.getCode()));
            }
            if (progress != null) {
                summary.setProgress(ProgressFormatter.format(progress));
            } else {
                summary.setProgress(executionPE.getSummaryProgress());
            }
        }
        if (fetchOptions.hasError()) {
            summary.setError(executionPE.getSummaryError());
        }
        if (fetchOptions.hasResults()) {
            summary.setResults(executionPE.getSummaryResultsList());
        }
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationExecutionDetails translateDetails(IOperationContext context, OperationExecutionPE executionPE, OperationExecutionDetailsFetchOptions fetchOptions) {
        OperationExecutionFS executionFS;
        OperationExecutionAvailability detailsAvailability = this.convertAvailability(executionPE.getDetailsAvailability());
        if (OperationExecutionAvailability.TIMED_OUT.equals((Object)detailsAvailability) || OperationExecutionAvailability.DELETED.equals((Object)detailsAvailability)) {
            return null;
        }
        OperationExecutionFSFetchOptions fetchOptionsFS = new OperationExecutionFSFetchOptions();
        if (fetchOptions.hasOperations()) {
            fetchOptionsFS.withOperations();
        }
        if (fetchOptions.hasProgress()) {
            fetchOptionsFS.withProgress();
        }
        if (fetchOptions.hasError()) {
            fetchOptionsFS.withError();
        }
        if (fetchOptions.hasResults()) {
            fetchOptionsFS.withResults();
        }
        if ((executionFS = this.fsStore.getExecution(executionPE.getCode(), fetchOptionsFS)) == null) {
            return null;
        }
        OperationExecutionDetails details = new OperationExecutionDetails();
        details.setFetchOptions(fetchOptions);
        if (fetchOptions.hasOperations()) {
            details.setOperations(executionFS.getOperations());
        }
        if (fetchOptions.hasProgress()) {
            IProgress progress = null;
            Map<OperationExecutionPermId, IProgress> map = this.progressMap;
            synchronized (map) {
                progress = this.progressMap.get(new OperationExecutionPermId(executionPE.getCode()));
            }
            if (progress != null) {
                details.setProgress((IOperationExecutionProgress)new OperationExecutionProgress(ProgressFormatter.format(progress), progress.getNumItemsProcessed(), progress.getTotalItemsToProcess()));
            } else {
                details.setProgress(executionFS.getProgress());
            }
        }
        if (fetchOptions.hasError()) {
            details.setError(executionFS.getError());
        }
        if (fetchOptions.hasResults()) {
            details.setResults(executionFS.getResults());
        }
        return details;
    }

    private IOperationExecutionNotification translateNotification(IOperationExecutionId executionId, String notification) {
        if (notification == null || notification.trim().isEmpty()) {
            return null;
        }
        try {
            return (IOperationExecutionNotification)this.objectMapper.readValue(notification, Object.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read notification configuration for operation execution id " + executionId, e);
        }
    }

    private String translateNotification(IOperationExecutionId executionId, IOperationExecutionNotification notification) {
        if (notification == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsString((Object)notification);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write notification configuration for operation execution id " + executionId, e);
        }
    }

    private void checkContext(IOperationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
    }

    private void checkExecutionId(IOperationExecutionId executionId) {
        if (executionId == null) {
            throw new IllegalArgumentException("Execution id cannot be null");
        }
        if (!(executionId instanceof OperationExecutionPermId)) {
            throw new UnsupportedObjectIdException((IObjectId)executionId);
        }
    }

    private void checkExecution(IOperationExecutionId executionId, OperationExecutionPE executionPE) {
        if (executionPE == null) {
            throw new IllegalArgumentException("Operation execution with id " + executionId + " does not exist in the database.");
        }
    }

    private void checkOperations(List<? extends IOperation> operations) {
        if (operations == null || operations.isEmpty()) {
            throw new IllegalArgumentException("Operations cannot be null or empty");
        }
    }

    private void checkOptions(IOperationExecutionOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Options cannot be null");
        }
    }

    private void checkError(IOperationExecutionError error) {
        if (error == null) {
            throw new IllegalArgumentException("Error cannot be null");
        }
    }

    private void checkResults(List<? extends IOperationResult> results) {
        if (results == null || results.isEmpty()) {
            throw new IllegalArgumentException("Results cannot be null or empty");
        }
    }

    private void checkAvailability(OperationExecutionPermId executionId, ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionAvailability previousCore, OperationExecutionAvailability next) {
        if (next == null) {
            throw new IllegalArgumentException("Opeation execution with id " + executionId + " cannot have availability set to null");
        }
        OperationExecutionAvailability previous = this.convertAvailability(previousCore);
        if (next.equals((Object)previous)) {
            return;
        }
        if (!next.hasPrevious(previous)) {
            throw new IllegalArgumentException("Opeation execution with id " + executionId + " cannot have availability changed from " + previous + " to " + next);
        }
    }

    private ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionState convertState(OperationExecutionState state) {
        return ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.OperationExecutionState.valueOf((String)state.name());
    }

    private ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionAvailability convertAvailability(OperationExecutionAvailability availability) {
        return ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionAvailability.valueOf(availability.name());
    }

    private OperationExecutionAvailability convertAvailability(ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionAvailability availability) {
        return OperationExecutionAvailability.valueOf((String)availability.name());
    }

    private void checkAccess(IOperationContext context) {
        this.authorization.canGet(context);
    }

    private void checkAccess(IOperationContext context, OperationExecutionPE executionPE) {
        try {
            this.authorization.canGet(context);
        }
        catch (AuthorizationFailureException ex) {
            throw new UnauthorizedObjectAccessException((IObjectId)new OperationExecutionPermId(executionPE.getCode()));
        }
        if (!this.authorization.canGet(context, executionPE)) {
            throw new UnauthorizedObjectAccessException((IObjectId)new OperationExecutionPermId(executionPE.getCode()));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void shutdown() {
        if (this.progressThread != null) {
            this.progressThread.interrupt();
        }
    }
}

