/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.create.PersonCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.PersonPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractCreateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.ICreatePersonExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.IPersonAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.ISetPersonSpaceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.CommonUtils;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CreateProgress;
import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.server.AuthenticationServiceHolder;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class CreatePersonExecutor
extends AbstractCreateEntityExecutor<PersonCreation, PersonPE, PersonPermId>
implements ICreatePersonExecutor {
    private static final String ALLOW_MISSING_USER_CREATION_PROPERTY = "allow-missing-user-creation";
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private ISetPersonSpaceExecutor setPersonSpaceExecutor;
    @Autowired
    private AuthenticationServiceHolder authenticationServiceHolder;
    @Autowired
    private IPersonAuthorizationExecutor authorizationExecutor;
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;

    @Override
    protected IObjectId getId(PersonPE entity) {
        return new PersonPermId(entity.getUserId());
    }

    @Override
    protected void checkData(IOperationContext context, PersonCreation creation) {
        if (StringUtils.isEmpty((CharSequence)creation.getUserId())) {
            throw new UserFailureException("Unspecified user id.");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context) {
        this.authorizationExecutor.canCreate(context);
    }

    @Override
    protected void checkAccess(IOperationContext context, PersonPE entity) {
    }

    @Override
    protected List<PersonPE> createEntities(IOperationContext context, CollectionBatch<PersonCreation> batch) {
        final LinkedList<PersonPE> persons = new LinkedList<PersonPE>();
        final ArrayList unknownUsers = new ArrayList();
        final DisplaySettings displaySettings = this.getDefaultDisplaySettings();
        final PersonPE registrator = context.getSession().tryGetPerson();
        final boolean allowMissingUserCreation = PropertyUtils.getBoolean((Properties)this.configurer.getResolvedProps(), (String)ALLOW_MISSING_USER_CREATION_PROPERTY, (boolean)false);
        final IAuthenticationService authenticationService = this.authenticationServiceHolder.getAuthenticationService();
        new CollectionBatchProcessor<PersonCreation>(context, batch){

            @Override
            public void process(PersonCreation personCreation) {
                String userId = personCreation.getUserId();
                PersonPE person = new PersonPE();
                person.setDisplaySettings(displaySettings);
                person.setActive(true);
                person.setRegistrator(registrator);
                try {
                    Principal principal = authenticationService.getPrincipal(userId);
                    person.setUserId(principal.getUserId());
                    person.setFirstName(principal.getFirstName());
                    person.setLastName(principal.getLastName());
                    person.setEmail(principal.getEmail());
                    persons.add(person);
                }
                catch (IllegalArgumentException ex) {
                    if (allowMissingUserCreation) {
                        person.setUserId(CreatePersonExecutor.this.normalizeUserId(userId));
                        persons.add(person);
                    }
                    unknownUsers.add(userId);
                }
            }

            @Override
            public IProgress createProgress(PersonCreation object, int objectIndex, int totalObjectCount) {
                return new CreateProgress((ICreation)object, objectIndex, totalObjectCount);
            }
        };
        if (unknownUsers.size() > 0) {
            throw UserFailureException.fromTemplate((String)"Following persons unknown by the authentication service: [%s]", (Object[])new Object[]{StringUtils.join(unknownUsers, (String)",")});
        }
        return persons;
    }

    private String normalizeUserId(String userId) {
        return userId.replace("@", "_AT_");
    }

    private DisplaySettings getDefaultDisplaySettings() {
        PersonPE systemUser = this.daoFactory.getPersonDAO().tryFindPersonByUserId("system");
        if (systemUser == null) {
            throw new UserFailureException("Couldn't find system user with default settings in the DB.");
        }
        return systemUser.getDisplaySettings();
    }

    @Override
    protected PersonPermId createPermId(IOperationContext context, PersonPE entity) {
        return new PersonPermId(entity.getUserId());
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<PersonCreation, PersonPE> batch) {
        this.setPersonSpaceExecutor.set(context, batch);
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<PersonCreation, PersonPE> batch) {
    }

    @Override
    protected List<PersonPE> list(IOperationContext context, Collection<Long> ids) {
        return CommonUtils.listPersons(this.daoFactory, ids);
    }

    @Override
    protected void save(IOperationContext context, List<PersonPE> entities, boolean clearCache) {
        for (PersonPE person : entities) {
            try {
                this.daoFactory.getPersonDAO().createPerson(person);
            }
            catch (DataAccessException e) {
                throw new UserFailureException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "person", null);
    }
}

