/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.delete.PersonDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.IPersonId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.IDeletePersonExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.IMapPersonByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.IPersonAuthorizationExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeletePersonExecutor
extends AbstractDeleteEntityExecutor<Void, IPersonId, PersonPE, PersonDeletionOptions>
implements IDeletePersonExecutor {
    @Autowired
    private IMapPersonByIdExecutor mapPersonByIdExecutor;
    @Autowired
    private IPersonAuthorizationExecutor authorizationExecutor;

    @Override
    protected Map<IPersonId, PersonPE> map(IOperationContext context, List<? extends IPersonId> entityIds, PersonDeletionOptions deletionOptions) {
        return this.mapPersonByIdExecutor.map(context, entityIds);
    }

    @Override
    protected void checkAccess(IOperationContext context, IPersonId entityId, PersonPE entity) {
        this.authorizationExecutor.canDelete(context);
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, PersonPE entity) {
    }

    @Override
    protected Void delete(IOperationContext context, Collection<PersonPE> persons, PersonDeletionOptions deletionOptions) {
        for (PersonPE person : persons) {
            if (person.equals(context.getSession().tryGetPerson()) || person.equals(context.getSession().tryGetCreatorPerson())) {
                throw new UserFailureException("You cannot remove your own user.");
            }
            this.daoFactory.getPersonDAO().delete(person);
        }
        return null;
    }
}

