/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.Me;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.PersonPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.search.EmailSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.search.FirstNameSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.search.LastNameSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.search.PersonSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.search.UserIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.search.UserIdsSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.StringFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.IPersonAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.ISearchPersonExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchPersonExecutor
extends AbstractSearchObjectManuallyExecutor<PersonSearchCriteria, PersonPE>
implements ISearchPersonExecutor {
    @Autowired
    private IPersonAuthorizationExecutor authorizationExecutor;

    @Override
    public List<PersonPE> search(IOperationContext context, PersonSearchCriteria criteria) {
        this.authorizationExecutor.canGet(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<PersonPE> listAll() {
        return this.daoFactory.getPersonDAO().listAllEntities();
    }

    @Override
    protected Matcher<PersonPE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof UserIdSearchCriteria) {
            return new UserIdMatcher();
        }
        if (criteria instanceof UserIdsSearchCriteria) {
            return new UserIdsMatcher();
        }
        if (criteria instanceof FirstNameSearchCriteria) {
            return new FirstNameMatcher();
        }
        if (criteria instanceof LastNameSearchCriteria) {
            return new LastNameMatcher();
        }
        if (criteria instanceof EmailSearchCriteria) {
            return new EmailMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class EmailMatcher
    extends StringFieldMatcher<PersonPE> {
        private EmailMatcher() {
        }

        @Override
        protected String getFieldValue(PersonPE object) {
            return object.getEmail();
        }
    }

    private class LastNameMatcher
    extends StringFieldMatcher<PersonPE> {
        private LastNameMatcher() {
        }

        @Override
        protected String getFieldValue(PersonPE object) {
            return object.getLastName();
        }
    }

    private class FirstNameMatcher
    extends StringFieldMatcher<PersonPE> {
        private FirstNameMatcher() {
        }

        @Override
        protected String getFieldValue(PersonPE object) {
            return object.getFirstName();
        }
    }

    private class UserIdsMatcher
    extends SimpleFieldMatcher<PersonPE> {
        private UserIdsMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, PersonPE person, ISearchCriteria criteria) {
            Collection userIds = (Collection)((UserIdsSearchCriteria)criteria).getFieldValue();
            if (userIds == null || userIds.isEmpty()) {
                return true;
            }
            for (String userId : userIds) {
                if (!person.getUserId().equals(userId)) continue;
                return true;
            }
            return false;
        }
    }

    private class UserIdMatcher
    extends StringFieldMatcher<PersonPE> {
        private UserIdMatcher() {
        }

        @Override
        protected String getFieldValue(PersonPE object) {
            return object.getUserId();
        }
    }

    private class IdMatcher
    extends SimpleFieldMatcher<PersonPE> {
        private IdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, PersonPE object, ISearchCriteria criteria) {
            IObjectId id = ((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof PersonPermId) {
                return object.getUserId().equals(((PersonPermId)id).getPermId());
            }
            if (id instanceof Me) {
                PersonPE person = context.getSession().tryGetPerson();
                if (person != null) {
                    return object.getUserId().equals(person.getUserId());
                }
                throw new IllegalArgumentException("Unspecified session user");
            }
            throw new IllegalArgumentException("Unknown id: " + criteria.getClass());
        }
    }
}

