/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.FieldUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.update.PersonUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.ISpaceId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityToOneRelationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.IPersonAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.IUpdateHomeSpaceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.IMapSpaceByIdExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateHomeSpaceExecutor
extends AbstractUpdateEntityToOneRelationExecutor<PersonUpdate, PersonPE, ISpaceId, SpacePE>
implements IUpdateHomeSpaceExecutor {
    @Autowired
    private IMapSpaceByIdExecutor mapSpaceByIdExecutor;
    @Autowired
    private IPersonAuthorizationExecutor authorizationExecutor;

    @Override
    protected String getRelationName() {
        return "person-space";
    }

    @Override
    protected ISpaceId getRelatedId(SpacePE related) {
        return new SpacePermId(related.getCode());
    }

    @Override
    protected SpacePE getCurrentlyRelated(PersonPE entity) {
        return entity.getHomeSpace();
    }

    @Override
    protected FieldUpdateValue<ISpaceId> getRelatedUpdate(PersonUpdate update) {
        return update.getSpaceId();
    }

    @Override
    protected Map<ISpaceId, SpacePE> map(IOperationContext context, List<ISpaceId> relatedIds) {
        return this.mapSpaceByIdExecutor.map(context, relatedIds);
    }

    @Override
    protected void check(IOperationContext context, PersonPE user, ISpaceId relatedId, SpacePE newHomeSpace) {
        PersonPE sessionUser = context.getSession().tryGetPerson();
        if (!sessionUser.equals(user)) {
            this.authorizationExecutor.canUpdateHomeSpace(context, newHomeSpace);
        }
    }

    @Override
    protected void update(IOperationContext context, PersonPE entity, SpacePE related) {
        entity.setHomeSpace(related);
    }
}

