/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.IPersonId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.Me;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.PersonPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.update.PersonUpdate;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.IMapPersonByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.IPersonAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.IUpdateHomeSpaceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.IUpdatePersonExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.IUpdateWebAppSettingsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.CommonUtils;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRoleAssignmentDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class UpdatePersonExecutor
extends AbstractUpdateEntityExecutor<PersonUpdate, PersonPE, IPersonId, PersonPermId>
implements IUpdatePersonExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IPersonAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IMapPersonByIdExecutor mapPersonByIdExecutor;
    @Autowired
    private IUpdateHomeSpaceExecutor updateHomeSpaceExecutor;
    @Autowired
    private IUpdateWebAppSettingsExecutor updateWebAppSettingsExecutor;

    @Override
    protected IPersonId getId(PersonUpdate update) {
        return update.getUserId();
    }

    @Override
    protected PersonPermId getPermId(PersonPE entity) {
        return new PersonPermId(entity.getUserId());
    }

    @Override
    protected void checkData(IOperationContext context, PersonUpdate update) {
        IPersonId personId = update.getUserId();
        if (personId == null || personId instanceof Me) {
            PersonPE person = context.getSession().tryGetPerson();
            if (person != null) {
                update.setUserId((IPersonId)new PersonPermId(person.getUserId()));
            } else {
                throw new UserFailureException("Person to be updated not specified.");
            }
        }
    }

    @Override
    protected void checkAccess(IOperationContext context, IPersonId id, PersonPE entity) {
        if (!entity.isActive()) {
            this.authorizationExecutor.canDeactivate(context);
        }
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<PersonUpdate, PersonPE> batch) {
        this.updateHomeSpaceExecutor.update(context, batch);
        this.updateWebAppSettingsExecutor.update(context, batch);
        Set entrySet = ((Map)batch.getObjects()).entrySet();
        for (Map.Entry entry : entrySet) {
            PersonUpdate personUpdate = (PersonUpdate)entry.getKey();
            PersonPE person = (PersonPE)entry.getValue();
            if (personUpdate.isActive() == null || !personUpdate.isActive().isModified() || personUpdate.isActive().getValue() == null) continue;
            if (person.isActive() && !((Boolean)personUpdate.isActive().getValue()).booleanValue()) {
                this.deactivate(context, person);
                continue;
            }
            if (person.isActive() || !((Boolean)personUpdate.isActive().getValue()).booleanValue()) continue;
            this.activate(context, person);
        }
    }

    private void deactivate(IOperationContext context, PersonPE person) {
        this.authorizationExecutor.canDeactivate(context);
        if (person.equals(context.getSession().tryGetPerson())) {
            throw new UserFailureException("You can not deactivate yourself. Ask another instance admin to do that for you.");
        }
        IRoleAssignmentDAO roleAssignmenDAO = this.daoFactory.getRoleAssignmentDAO();
        person.setActive(false);
        person.setDisplaySettings(null);
        person.clearAuthorizationGroups();
        ArrayList<RoleAssignmentPE> roleAssignments = new ArrayList<RoleAssignmentPE>(person.getRoleAssignments());
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            roleAssignmenDAO.deleteRoleAssignment(roleAssignment);
        }
    }

    private void activate(IOperationContext context, PersonPE person) {
        this.authorizationExecutor.canActivate(context);
        person.setActive(true);
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<PersonUpdate, PersonPE> batch) {
    }

    @Override
    protected Map<IPersonId, PersonPE> map(IOperationContext context, Collection<IPersonId> ids) {
        return this.mapPersonByIdExecutor.map(context, ids);
    }

    @Override
    protected List<PersonPE> list(IOperationContext context, Collection<Long> ids) {
        return CommonUtils.listPersons(this.daoFactory, ids);
    }

    @Override
    protected void save(IOperationContext context, List<PersonPE> entities, boolean clearCache) {
        for (PersonPE person : entities) {
            this.daoFactory.getPersonDAO().updatePerson(person);
        }
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "person", null);
    }
}

