/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.ListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.PersonPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.update.PersonUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.create.WebAppSettingCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.update.WebAppSettingsUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.IUpdateWebAppSettingsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.UpdateRelationProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.roleassignment.RoleAssignmentUtils;
import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.DisplaySettingsProvider;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.displaysettings.IDisplaySettingsUpdate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateWebAppSettingsExecutor
implements IUpdateWebAppSettingsExecutor {
    @Autowired
    private DisplaySettingsProvider displaySettingsProvider;
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    public void update(final IOperationContext context, MapBatch<PersonUpdate, PersonPE> batch) {
        new MapBatchProcessor<PersonUpdate, PersonPE>(context, batch){

            @Override
            public void process(PersonUpdate update, PersonPE person) {
                Map webAppSettingsMap = update.getWebAppSettings();
                if (webAppSettingsMap != null) {
                    for (Map.Entry entry : webAppSettingsMap.entrySet()) {
                        UpdateWebAppSettingsExecutor.this.update(context, person, (String)entry.getKey(), (WebAppSettingsUpdateValue)entry.getValue());
                    }
                }
            }

            @Override
            public IProgress createProgress(PersonUpdate update, PersonPE person, int objectIndex, int totalObjectCount) {
                return new UpdateRelationProgress((IUpdate)update, person, "person-web-app-settings", objectIndex, totalObjectCount);
            }
        };
    }

    private void update(final IOperationContext context, PersonPE person, final String webAppId, final WebAppSettingsUpdateValue webAppSettingsUpdate) {
        if (webAppId == null) {
            throw new UserFailureException("Web app id cannot be null");
        }
        if (webAppSettingsUpdate == null) {
            throw new UserFailureException("Web app settings update cannot be null");
        }
        if (webAppSettingsUpdate.getActions() != null && !webAppSettingsUpdate.getActions().isEmpty()) {
            PersonPE loggedInPerson = context.getSession().tryGetPerson();
            if (!person.equals(loggedInPerson) && !RoleAssignmentUtils.isInstanceAdmin(loggedInPerson)) {
                throw new UnauthorizedObjectAccessException((IObjectId)new PersonPermId(person.getUserId()));
            }
            this.updateDisplaySettings(person, new IDisplaySettingsUpdate(){
                private static final long serialVersionUID = 1L;

                @Override
                public DisplaySettings update(DisplaySettings displaySettings) {
                    UpdateWebAppSettingsExecutor.this.remove(context, displaySettings, webAppId, webAppSettingsUpdate);
                    UpdateWebAppSettingsExecutor.this.add(context, displaySettings, webAppId, webAppSettingsUpdate);
                    UpdateWebAppSettingsExecutor.this.set(context, displaySettings, webAppId, webAppSettingsUpdate);
                    return displaySettings;
                }
            });
        }
    }

    private void remove(IOperationContext context, DisplaySettings displaySettings, String webAppId, WebAppSettingsUpdateValue webAppSettingsUpdate) {
        Map<String, String> webAppSettings = displaySettings.getCustomWebAppSettings(webAppId);
        for (ListUpdateValue.ListUpdateAction action : webAppSettingsUpdate.getActions()) {
            Collection names;
            if (!(action instanceof ListUpdateValue.ListUpdateActionRemove) || (names = action.getItems()) == null) continue;
            for (String name : names) {
                if (name == null) {
                    throw new UserFailureException("Web app setting name cannot be null");
                }
                webAppSettings.remove(name);
            }
        }
        if (webAppSettings.isEmpty()) {
            displaySettings.removeCustomWebAppSettings(webAppId);
        }
    }

    private void add(IOperationContext context, DisplaySettings displaySettings, String webAppId, WebAppSettingsUpdateValue webAppSettingsUpdate) {
        Map<String, String> webAppSettings = displaySettings.getCustomWebAppSettings(webAppId);
        for (ListUpdateValue.ListUpdateAction action : webAppSettingsUpdate.getActions()) {
            Collection creations;
            if (!(action instanceof ListUpdateValue.ListUpdateActionAdd) || (creations = action.getItems()) == null) continue;
            for (WebAppSettingCreation creation : creations) {
                if (creation == null) continue;
                if (creation.getName() == null) {
                    throw new UserFailureException("Web app setting name cannot be null");
                }
                webAppSettings.put(creation.getName(), creation.getValue());
            }
        }
        if (webAppSettings.isEmpty()) {
            displaySettings.removeCustomWebAppSettings(webAppId);
        }
    }

    private void set(IOperationContext context, DisplaySettings displaySettings, String webAppId, WebAppSettingsUpdateValue webAppSettingsUpdate) {
        ListUpdateValue.ListUpdateActionSet lastSet = null;
        for (ListUpdateValue.ListUpdateAction action : webAppSettingsUpdate.getActions()) {
            if (!(action instanceof ListUpdateValue.ListUpdateActionSet)) continue;
            lastSet = (ListUpdateValue.ListUpdateActionSet)action;
        }
        if (lastSet != null) {
            HashMap<String, String> settings = new HashMap<String, String>();
            if (lastSet.getItems() != null) {
                for (WebAppSettingCreation creation : lastSet.getItems()) {
                    if (creation == null) continue;
                    if (creation.getName() == null) {
                        throw new UserFailureException("Web app setting name cannot be null");
                    }
                    settings.put(creation.getName(), creation.getValue());
                }
            }
            if (settings.isEmpty()) {
                displaySettings.removeCustomWebAppSettings(webAppId);
            } else {
                displaySettings.setCustomWebAppSettings(webAppId, settings);
            }
        }
    }

    private void updateDisplaySettings(PersonPE person, final IDisplaySettingsUpdate displaySettingsUpdate) {
        Session hibernateSession = this.daoFactory.getSessionFactory().getCurrentSession();
        final PersonPE attachedPerson = (PersonPE)hibernateSession.get(PersonPE.class, (Serializable)person.getId());
        this.daoFactory.getPersonDAO().lock(attachedPerson);
        this.displaySettingsProvider.executeActionWithPersonLock(attachedPerson, new IDelegatedActionWithResult<Void>(){

            public Void execute(boolean didOperationSucceed) {
                DisplaySettings currentDisplaySettings = UpdateWebAppSettingsExecutor.this.displaySettingsProvider.getCurrentDisplaySettings(attachedPerson);
                DisplaySettings newDisplaySettings = displaySettingsUpdate.update(currentDisplaySettings);
                UpdateWebAppSettingsExecutor.this.displaySettingsProvider.replaceCurrentDisplaySettings(attachedPerson, newDisplaySettings);
                UpdateWebAppSettingsExecutor.this.daoFactory.getPersonDAO().updatePerson(attachedPerson);
                return null;
            }
        });
    }
}

