/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.plugin;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.PluginType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.create.PluginCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.id.PluginPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractCreateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.plugin.ICreatePluginExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.plugin.IPluginAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CreateProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.util.PluginUtils;
import ch.systemsx.cisd.openbis.generic.shared.IJythonEvaluatorPool;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class CreatePluginExecutor
extends AbstractCreateEntityExecutor<PluginCreation, ScriptPE, PluginPermId>
implements ICreatePluginExecutor {
    @Resource(name="jython-evaluator-pool")
    private IJythonEvaluatorPool evaluatorPool;
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IPluginAuthorizationExecutor authorizationExecutor;

    @Override
    protected IObjectId getId(ScriptPE entity) {
        return new PluginPermId(entity.getName());
    }

    @Override
    protected PluginPermId createPermId(IOperationContext context, ScriptPE entity) {
        return new PluginPermId(entity.getName());
    }

    @Override
    protected void checkData(IOperationContext context, PluginCreation creation) {
        if (StringUtils.isEmpty((CharSequence)creation.getName())) {
            throw new UserFailureException("Name cannot be empty.");
        }
        if (creation.getPluginType() == null) {
            throw new UserFailureException("Plugin type cannot be unspecified.");
        }
        if (StringUtils.isEmpty((CharSequence)creation.getScript())) {
            throw new UserFailureException("Script cannot be empty.");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context) {
        this.authorizationExecutor.canCreate(context);
    }

    @Override
    protected void checkAccess(IOperationContext context, ScriptPE entity) {
    }

    @Override
    protected List<ScriptPE> createEntities(IOperationContext context, CollectionBatch<PluginCreation> batch) {
        final ArrayList<ScriptPE> scripts = new ArrayList<ScriptPE>();
        final PersonPE person = context.getSession().tryGetPerson();
        new CollectionBatchProcessor<PluginCreation>(context, batch){

            @Override
            public void process(PluginCreation creation) {
                ScriptPE script = new ScriptPE();
                script.setName(creation.getName());
                script.setDescription(creation.getDescription());
                ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind entityKind = creation.getEntityKind();
                if (entityKind != null) {
                    script.setEntityKind(CreatePluginExecutor.this.translate(entityKind));
                }
                if (creation.getPluginType() != null) {
                    script.setScriptType(CreatePluginExecutor.this.translate(creation.getPluginType()));
                }
                script.setPluginType(ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType.JYTHON);
                script.setScript(creation.getScript());
                PluginUtils.checkScriptCompilation(script, CreatePluginExecutor.this.evaluatorPool);
                script.setAvailable(creation.isAvailable());
                script.setRegistrator(person);
                scripts.add(script);
            }

            @Override
            public IProgress createProgress(PluginCreation object, int objectIndex, int totalObjectCount) {
                return new CreateProgress((ICreation)object, objectIndex, totalObjectCount);
            }
        };
        return scripts;
    }

    private EntityKind translate(ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind entityKind) {
        return EntityKind.valueOf((String)entityKind.name());
    }

    private ScriptType translate(PluginType scriptType) {
        return ScriptType.valueOf(scriptType.name());
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<PluginCreation, ScriptPE> batch) {
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<PluginCreation, ScriptPE> batch) {
    }

    @Override
    protected List<ScriptPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getScriptDAO().listAllEntities();
    }

    @Override
    protected void save(IOperationContext context, List<ScriptPE> scripts, boolean clearCache) {
        for (ScriptPE script : scripts) {
            this.daoFactory.getScriptDAO().createOrUpdate(script);
        }
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "plugin", null);
    }
}

