/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.plugin;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.id.IMaterialId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.id.MaterialPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.evaluate.DynamicPropertyPluginEvaluationOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.evaluate.DynamicPropertyPluginEvaluationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.evaluate.EntityValidationPluginEvaluationOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.evaluate.EntityValidationPluginEvaluationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.evaluate.PluginEvaluationOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.evaluate.PluginEvaluationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.id.IPluginId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IMapDataSetByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IMapExperimentByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.material.IMapMaterialByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.plugin.IEvaluatePluginExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.plugin.IMapPluginByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.plugin.IPluginAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IMapSampleByIdExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.DynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyCalculatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.EntityAdaptorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.INonAbstractEntityAdapter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.JythonEntityValidationCalculator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IDynamicPropertyCalculator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.IEntityValidatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.api.IEntityValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.IEntityAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EvaluatePluginExecutor
implements IEvaluatePluginExecutor {
    @Autowired
    private IPluginAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IMapExperimentByIdExecutor mapExperimentByIdExecutor;
    @Autowired
    private IMapPluginByIdExecutor mapPluginByIdExecutor;
    @Autowired
    private IMapSampleByIdExecutor mapSampleByIdExecutor;
    @Autowired
    private IMapDataSetByIdExecutor mapDataSetByIdExecutor;
    @Autowired
    private IMapMaterialByIdExecutor mapMaterialByIdExecutor;
    @Autowired
    private IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory;
    @Autowired
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;
    @Autowired
    private IEntityValidatorFactory entityValidationFactory;
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    public PluginEvaluationResult execute(IOperationContext context, PluginEvaluationOptions options) {
        if (options == null) {
            throw new UserFailureException("Plugin evaluation options cannot be null");
        }
        if (options.getPluginId() == null && StringUtils.isBlank((CharSequence)options.getPluginScript())) {
            throw new UserFailureException("Plugin id and plugin script cannot be both null");
        }
        if (options.getPluginId() != null && !StringUtils.isBlank((CharSequence)options.getPluginScript())) {
            throw new UserFailureException("Plugin id and plugin script cannot be both specified");
        }
        this.authorizationExecutor.canEvaluate(context);
        if (options.getPluginId() != null) {
            ScriptPE plugin = this.getPlugin(context, options.getPluginId());
            if (plugin != null) {
                return this.evaluatePluginFromDatabase(context, plugin, options);
            }
            throw new ObjectNotFoundException((IObjectId)options.getPluginId());
        }
        return this.evaluatePluginFromScript(context, options);
    }

    private PluginEvaluationResult evaluatePluginFromDatabase(IOperationContext context, ScriptPE plugin, PluginEvaluationOptions options) {
        switch (plugin.getScriptType()) {
            case DYNAMIC_PROPERTY: {
                if (options instanceof DynamicPropertyPluginEvaluationOptions) {
                    return this.evaluateDynamicProperty(context, plugin.getName(), plugin.getPluginType(), plugin.getEntityKind(), plugin.getScript(), (DynamicPropertyPluginEvaluationOptions)options);
                }
                throw UserFailureException.fromTemplate((String)"'%s' is a dynamic property plugin. It requires '%s' evaluation options, but got '%s'", (Object[])new Object[]{options.getPluginId(), DynamicPropertyPluginEvaluationOptions.class.getSimpleName(), options.getClass().getSimpleName()});
            }
            case ENTITY_VALIDATION: {
                if (options instanceof EntityValidationPluginEvaluationOptions) {
                    return this.evaluateEntityValidation(context, plugin.getName(), plugin.getPluginType(), plugin.getEntityKind(), plugin.getScript(), (EntityValidationPluginEvaluationOptions)options);
                }
                throw UserFailureException.fromTemplate((String)"'%s' is an entity validation plugin. It requires '%s' evaluation options, but got '%s'", (Object[])new Object[]{options.getPluginId(), EntityValidationPluginEvaluationOptions.class.getSimpleName(), options.getClass().getSimpleName()});
            }
        }
        throw UserFailureException.fromTemplate((String)"Unsupported plugin type '%s'", (Object[])new Object[]{plugin.getScriptType()});
    }

    private PluginEvaluationResult evaluatePluginFromScript(IOperationContext context, PluginEvaluationOptions options) {
        if (options instanceof DynamicPropertyPluginEvaluationOptions) {
            return this.evaluateDynamicProperty(context, null, PluginType.JYTHON, null, options.getPluginScript(), (DynamicPropertyPluginEvaluationOptions)options);
        }
        if (options instanceof EntityValidationPluginEvaluationOptions) {
            return this.evaluateEntityValidation(context, null, PluginType.JYTHON, null, options.getPluginScript(), (EntityValidationPluginEvaluationOptions)options);
        }
        throw UserFailureException.fromTemplate((String)"Unsupported plugin evaluation options '%s'", (Object[])new Object[]{options.getClass().getSimpleName()});
    }

    public DynamicPropertyPluginEvaluationResult evaluateDynamicProperty(IOperationContext context, String pluginName, PluginType pluginType, EntityKind pluginEntityKind, String pluginScript, DynamicPropertyPluginEvaluationOptions options) {
        IEntityInformationWithPropertiesHolder entity = this.getEntity(context, pluginEntityKind, options.getObjectId());
        try {
            IDynamicPropertyCalculator calculator = this.dynamicPropertyCalculatorFactory.getCalculator(pluginType, pluginName, pluginScript);
            DynamicPropertyEvaluator evaluator = new DynamicPropertyEvaluator(this.daoFactory, null, this.dynamicPropertyCalculatorFactory, this.managedPropertyEvaluatorFactory);
            IEntityAdaptor adaptor = EntityAdaptorFactory.create(entity, (IDynamicPropertyEvaluator)evaluator, this.daoFactory.getSessionFactory().getCurrentSession());
            String value = calculator.eval(adaptor);
            return new DynamicPropertyPluginEvaluationResult(value);
        }
        catch (Throwable e) {
            if (options.getPluginId() != null) {
                throw UserFailureException.fromTemplate((Throwable)e, (String)"Evaluation of dynamic property plugin '%s' failed.", (Object[])new Object[]{options.getPluginId()});
            }
            throw UserFailureException.fromTemplate((Throwable)e, (String)"Evaluation of dynamic property plugin failed.", (Object[])new Object[0]);
        }
    }

    public EntityValidationPluginEvaluationResult evaluateEntityValidation(IOperationContext context, String pluginName, PluginType pluginType, EntityKind pluginEntityKind, String pluginScript, EntityValidationPluginEvaluationOptions options) {
        IEntityInformationWithPropertiesHolder entity = this.getEntity(context, pluginEntityKind, options.getObjectId());
        try {
            final LinkedHashSet requestedValidations = new LinkedHashSet();
            IEntityValidator entityValidator = this.entityValidationFactory.createEntityValidator(pluginType, pluginName, pluginScript);
            entityValidator.init(new JythonEntityValidationCalculator.IValidationRequestDelegate<INonAbstractEntityAdapter>(){

                @Override
                public void requestValidation(INonAbstractEntityAdapter entityAdaptor) {
                    IEntityInformationWithPropertiesHolder entity = entityAdaptor.entityPE();
                    ExperimentIdentifier id = null;
                    if (entity instanceof ExperimentPE) {
                        id = new ExperimentIdentifier(entity.getIdentifier());
                    } else if (entity instanceof SamplePE) {
                        id = new SampleIdentifier(entity.getIdentifier());
                    } else if (entity instanceof DataPE) {
                        id = new DataSetPermId(((DataPE)entity).getCode());
                    } else if (entity instanceof MaterialPE) {
                        id = new MaterialPermId(((MaterialPE)entity).getCode(), ((MaterialPE)entity).getEntityType().getCode());
                    }
                    requestedValidations.add(id);
                }
            });
            DynamicPropertyEvaluator evaluator = new DynamicPropertyEvaluator(this.daoFactory, null, this.dynamicPropertyCalculatorFactory, this.managedPropertyEvaluatorFactory);
            IEntityAdaptor adaptor = EntityAdaptorFactory.create(entity, (IDynamicPropertyEvaluator)evaluator, this.daoFactory.getSessionFactory().getCurrentSession());
            String error = entityValidator.validate(adaptor, options.isNew());
            return new EntityValidationPluginEvaluationResult(error, requestedValidations);
        }
        catch (Throwable e) {
            if (options.getPluginId() != null) {
                throw UserFailureException.fromTemplate((Throwable)e, (String)"Evaluation of entity validation plugin '%s' failed.", (Object[])new Object[]{options.getPluginId()});
            }
            throw UserFailureException.fromTemplate((Throwable)e, (String)"Evaluation of entity validation plugin failed.", (Object[])new Object[0]);
        }
    }

    private IEntityInformationWithPropertiesHolder getEntity(IOperationContext context, EntityKind pluginEntityKind, IObjectId objectId) {
        if (objectId == null) {
            throw new UserFailureException("Object id cannot be null");
        }
        Map objectMap = null;
        EntityKind objectEntityKind = null;
        if (objectId instanceof IExperimentId) {
            objectMap = this.mapExperimentByIdExecutor.map(context, Arrays.asList((IExperimentId)objectId));
            objectEntityKind = EntityKind.EXPERIMENT;
        } else if (objectId instanceof ISampleId) {
            objectMap = this.mapSampleByIdExecutor.map(context, Arrays.asList((ISampleId)objectId));
            objectEntityKind = EntityKind.SAMPLE;
        } else if (objectId instanceof IDataSetId) {
            objectMap = this.mapDataSetByIdExecutor.map(context, Arrays.asList((IDataSetId)objectId));
            objectEntityKind = EntityKind.DATA_SET;
        } else if (objectId instanceof IMaterialId) {
            objectMap = this.mapMaterialByIdExecutor.map(context, Arrays.asList((IMaterialId)objectId));
            objectEntityKind = EntityKind.MATERIAL;
        } else {
            throw new UserFailureException("Unsupported objectId: " + objectId);
        }
        IEntityInformationWithPropertiesHolder object = (IEntityInformationWithPropertiesHolder)objectMap.get(objectId);
        if (object == null) {
            throw new ObjectNotFoundException(objectId);
        }
        if (pluginEntityKind != null && pluginEntityKind != objectEntityKind) {
            throw UserFailureException.fromTemplate((String)"Cannot evaluate a plugin for object '%s'. The plugin expects objects with entity kind '%s' while the object has entity kind '%s'", (Object[])new Object[]{objectId, pluginEntityKind, objectEntityKind});
        }
        return object;
    }

    private ScriptPE getPlugin(IOperationContext context, IPluginId pluginId) {
        Map plugins = this.mapPluginByIdExecutor.map(context, Arrays.asList(pluginId));
        return (ScriptPE)plugins.get(pluginId);
    }
}

