/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.plugin;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdsSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NameSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.PluginKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.PluginType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.id.PluginPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.search.PluginKindSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.search.PluginSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.search.PluginTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractIdMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractIdsMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.StringFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.plugin.IPluginAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.plugin.ISearchPluginExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchPluginExecutor
extends AbstractSearchObjectManuallyExecutor<PluginSearchCriteria, ScriptPE>
implements ISearchPluginExecutor {
    @Autowired
    private IPluginAuthorizationExecutor authorizationExcutor;

    @Override
    public List<ScriptPE> search(IOperationContext context, PluginSearchCriteria criteria) {
        this.authorizationExcutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<ScriptPE> listAll() {
        return this.daoFactory.getScriptDAO().listAllEntities();
    }

    @Override
    protected Matcher<ScriptPE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof IdsSearchCriteria) {
            return new IdsMatcher();
        }
        if (criteria instanceof NameSearchCriteria) {
            return new NameMatcher();
        }
        if (criteria instanceof PluginKindSearchCriteria) {
            return new PluginKindMatcher();
        }
        if (criteria instanceof PluginTypeSearchCriteria) {
            return new PluginTypeMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private static final class PluginTypeMatcher
    extends SimpleFieldMatcher<ScriptPE> {
        private PluginTypeMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, ScriptPE script, ISearchCriteria criteria) {
            PluginType fieldValue = (PluginType)((PluginTypeSearchCriteria)criteria).getFieldValue();
            return fieldValue == null ? true : script.getScriptType().name().equals(fieldValue.name());
        }
    }

    private static final class PluginKindMatcher
    extends SimpleFieldMatcher<ScriptPE> {
        private PluginKindMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, ScriptPE script, ISearchCriteria criteria) {
            PluginKind fieldValue = (PluginKind)((PluginKindSearchCriteria)criteria).getFieldValue();
            return fieldValue == null ? true : script.getPluginType().name().equals(fieldValue.name());
        }
    }

    private static final class NameMatcher
    extends StringFieldMatcher<ScriptPE> {
        private NameMatcher() {
        }

        @Override
        protected String getFieldValue(ScriptPE plugin) {
            return plugin.getName();
        }
    }

    private class IdsMatcher
    extends AbstractIdsMatcher<ScriptPE> {
        private IdsMatcher() {
        }

        @Override
        protected boolean addPermIdIfPossible(Collection<String> permIds, IObjectId id) {
            if (!(id instanceof PluginPermId)) {
                return false;
            }
            permIds.add(((PluginPermId)id).getPermId());
            return true;
        }
    }

    private class IdMatcher
    extends AbstractIdMatcher<ScriptPE> {
        private IdMatcher() {
        }

        @Override
        protected AbstractIdsMatcher<ScriptPE> createIdsMatcher() {
            return new IdsMatcher();
        }
    }
}

