/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.create.AttachmentCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.create.ProjectCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.attachment.ICreateAttachmentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractCreateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.ICreateProjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IProjectAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.ISetProjectLeaderExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.ISetProjectSpaceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CreateProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class CreateProjectExecutor
extends AbstractCreateEntityExecutor<ProjectCreation, ProjectPE, ProjectPermId>
implements ICreateProjectExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private ISetProjectSpaceExecutor setProjectSpaceExecutor;
    @Autowired
    private ISetProjectLeaderExecutor setProjectLeaderExecutor;
    @Autowired
    private ICreateAttachmentExecutor createAttachmentExecutor;
    @Autowired
    private IProjectAuthorizationExecutor authorizationExecutor;

    @Override
    protected List<ProjectPE> createEntities(IOperationContext context, CollectionBatch<ProjectCreation> batch) {
        final LinkedList<ProjectPE> projects = new LinkedList<ProjectPE>();
        final PersonPE person = context.getSession().tryGetPerson();
        final Date timeStamp = this.daoFactory.getTransactionTimestamp();
        new CollectionBatchProcessor<ProjectCreation>(context, batch){

            @Override
            public void process(ProjectCreation object) {
                ProjectPE project = new ProjectPE();
                project.setCode(object.getCode());
                String createdPermId = CreateProjectExecutor.this.daoFactory.getPermIdDAO().createPermId();
                project.setPermId(createdPermId);
                project.setDescription(object.getDescription());
                project.setRegistrator(person);
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)project, person, timeStamp);
                projects.add(project);
            }

            @Override
            public IProgress createProgress(ProjectCreation object, int objectIndex, int totalObjectCount) {
                return new CreateProgress((ICreation)object, objectIndex, totalObjectCount);
            }
        };
        return projects;
    }

    @Override
    protected ProjectPermId createPermId(IOperationContext context, ProjectPE entity) {
        return new ProjectPermId(entity.getPermId());
    }

    @Override
    protected void checkData(IOperationContext context, ProjectCreation creation) {
        if (StringUtils.isEmpty((CharSequence)creation.getCode())) {
            throw new UserFailureException("Code cannot be empty.");
        }
        ProjectIdentifierFactory.assertValidCode(creation.getCode());
    }

    @Override
    protected void checkAccess(IOperationContext context) {
    }

    @Override
    protected void checkAccess(IOperationContext context, ProjectPE entity) {
        this.authorizationExecutor.canCreate(context, entity);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<ProjectCreation, ProjectPE> batch) {
        this.setProjectSpaceExecutor.set(context, batch);
        this.setProjectLeaderExecutor.set(context, batch);
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<ProjectCreation, ProjectPE> batch) {
        HashMap<AttachmentHolderPE, Collection<? extends AttachmentCreation>> attachmentMap = new HashMap<AttachmentHolderPE, Collection<? extends AttachmentCreation>>();
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            ProjectCreation creation = (ProjectCreation)entry.getKey();
            ProjectPE entity = (ProjectPE)entry.getValue();
            attachmentMap.put(entity, creation.getAttachments());
        }
        this.createAttachmentExecutor.create(context, attachmentMap);
    }

    @Override
    protected List<ProjectPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getProjectDAO().listByIDs(ids);
    }

    @Override
    protected void save(IOperationContext context, List<ProjectPE> entities, boolean clearCache) {
        for (ProjectPE entity : entities) {
            this.daoFactory.getProjectDAO().createProject(entity, context.getSession().tryGetPerson());
        }
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "project", null);
    }

    @Override
    protected IObjectId getId(ProjectPE entity) {
        return new ProjectIdentifier(entity.getIdentifier());
    }
}

