/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.delete.ProjectDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.IProjectId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IDeleteProjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IMapProjectByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IProjectAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IProjectBO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteProjectExecutor
extends AbstractDeleteEntityExecutor<Void, IProjectId, ProjectPE, ProjectDeletionOptions>
implements IDeleteProjectExecutor {
    @Autowired
    private IMapProjectByIdExecutor mapProjectByIdExecutor;
    @Autowired
    private IProjectAuthorizationExecutor authorizationExecutor;

    @Override
    protected Map<IProjectId, ProjectPE> map(IOperationContext context, List<? extends IProjectId> entityIds, ProjectDeletionOptions deletionOptions) {
        return this.mapProjectByIdExecutor.map(context, entityIds);
    }

    @Override
    protected void checkAccess(IOperationContext context, IProjectId entityId, ProjectPE entity) {
        this.authorizationExecutor.canDelete(context, entityId, entity);
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, ProjectPE entity) {
    }

    @Override
    protected Void delete(IOperationContext context, Collection<ProjectPE> projects, ProjectDeletionOptions deletionOptions) {
        IProjectBO projectBO = this.businessObjectFactory.createProjectBO(context.getSession());
        for (ProjectPE project : projects) {
            projectBO.deleteByTechId(new TechId(project.getId()), deletionOptions.getReason());
        }
        return null;
    }
}

