/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.IProjectId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.get.AbstractMapObjectByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IMapProjectByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IProjectAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.IListObjectById;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.project.ListProjectByIdentifier;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.project.ListProjectByPermId;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IProjectDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MapProjectByIdExecutor
extends AbstractMapObjectByIdExecutor<IProjectId, ProjectPE>
implements IMapProjectByIdExecutor {
    private IProjectDAO projectDAO;
    @Autowired
    private IProjectAuthorizationExecutor authorizationExecutor;

    private MapProjectByIdExecutor() {
    }

    public MapProjectByIdExecutor(IProjectDAO projectDAO, IProjectAuthorizationExecutor authorizationExecutor) {
        this.projectDAO = projectDAO;
        this.authorizationExecutor = authorizationExecutor;
    }

    @Override
    protected void checkAccess(IOperationContext context) {
        this.authorizationExecutor.canGet(context);
    }

    @Override
    protected void addListers(IOperationContext context, List<IListObjectById<? extends IProjectId, ProjectPE>> listers) {
        listers.add(new ListProjectByIdentifier(this.projectDAO));
        listers.add(new ListProjectByPermId(this.projectDAO));
    }

    @Autowired
    private void setDAOFactory(IDAOFactory daoFactory) {
        this.projectDAO = daoFactory.getProjectDAO();
    }
}

