/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.search.ProjectSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.search.SpaceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodeMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodesMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.StringFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IProjectAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.ISearchProjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.ISearchSpaceExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchProjectExecutor
extends AbstractSearchObjectManuallyExecutor<ProjectSearchCriteria, ProjectPE>
implements ISearchProjectExecutor {
    @Autowired
    private ISearchSpaceExecutor searchSpaceExecutor;
    @Autowired
    private IProjectAuthorizationExecutor authorizationExecutor;

    @Override
    public List<ProjectPE> search(IOperationContext context, ProjectSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<ProjectPE> listAll() {
        return this.daoFactory.getProjectDAO().listAllEntities();
    }

    @Override
    protected Matcher<ProjectPE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof CodeSearchCriteria) {
            return new CodeMatcher<ProjectPE>();
        }
        if (criteria instanceof CodesSearchCriteria) {
            return new CodesMatcher<ProjectPE>();
        }
        if (criteria instanceof PermIdSearchCriteria) {
            return new PermIdMatcher();
        }
        if (criteria instanceof SpaceSearchCriteria) {
            return new SpaceMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class SpaceMatcher
    extends Matcher<ProjectPE> {
        private SpaceMatcher() {
        }

        @Override
        public List<ProjectPE> getMatching(IOperationContext context, List<ProjectPE> objects, ISearchCriteria criteria) {
            List spaceList = SearchProjectExecutor.this.searchSpaceExecutor.search(context, (SpaceSearchCriteria)criteria);
            HashSet spaceSet = new HashSet(spaceList);
            ArrayList<ProjectPE> matches = new ArrayList<ProjectPE>();
            for (ProjectPE object : objects) {
                if (!spaceSet.contains(object.getSpace())) continue;
                matches.add(object);
            }
            return matches;
        }
    }

    private class PermIdMatcher
    extends StringFieldMatcher<ProjectPE> {
        private PermIdMatcher() {
        }

        @Override
        protected String getFieldValue(ProjectPE object) {
            return object.getPermId();
        }
    }

    private class IdMatcher
    extends SimpleFieldMatcher<ProjectPE> {
        private IdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, ProjectPE object, ISearchCriteria criteria) {
            IObjectId id = ((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof ProjectPermId) {
                return object.getPermId().equals(((ProjectPermId)id).getPermId());
            }
            if (id instanceof ProjectIdentifier) {
                return object.getIdentifier().equals(((ProjectIdentifier)id).getIdentifier());
            }
            throw new IllegalArgumentException("Unknown id: " + criteria.getClass());
        }
    }
}

