/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.IProjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.update.ProjectUpdate;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.IEventExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IMapProjectByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IProjectAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IUpdateProjectAttachmentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IUpdateProjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IUpdateProjectSpaceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.FreezingEvent;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.FreezingFlags;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.UpdateRelationProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class UpdateProjectExecutor
extends AbstractUpdateEntityExecutor<ProjectUpdate, ProjectPE, IProjectId, ProjectPermId>
implements IUpdateProjectExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapProjectByIdExecutor mapProjectByIdExecutor;
    @Autowired
    private IUpdateProjectSpaceExecutor updateProjectSpaceExecutor;
    @Autowired
    private IUpdateProjectAttachmentExecutor updateProjectAttachmentExecutor;
    @Autowired
    private IProjectAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IEventExecutor eventExecutor;

    @Override
    protected IProjectId getId(ProjectUpdate update) {
        return update.getProjectId();
    }

    @Override
    protected ProjectPermId getPermId(ProjectPE entity) {
        return new ProjectPermId(entity.getPermId());
    }

    @Override
    protected void checkData(IOperationContext context, ProjectUpdate update) {
        if (update.getProjectId() == null) {
            throw new UserFailureException("Project id cannot be null.");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context, IProjectId id, ProjectPE entity) {
        this.authorizationExecutor.canUpdate(context, id, entity);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<ProjectUpdate, ProjectPE> batch) {
        this.updateProjectSpaceExecutor.update(context, batch);
        this.updateAttachments(context, batch);
        PersonPE person = context.getSession().tryGetPerson();
        Date timeStamp = this.daoFactory.getTransactionTimestamp();
        ArrayList<FreezingEvent> freezingEvents = new ArrayList<FreezingEvent>();
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            ProjectUpdate update = (ProjectUpdate)entry.getKey();
            ProjectPE project = (ProjectPE)entry.getValue();
            FreezingFlags freezingFlags = new FreezingFlags();
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)project, person, timeStamp);
            if (update.getDescription() != null && update.getDescription().isModified()) {
                project.setDescription((String)update.getDescription().getValue());
            }
            if (update.shouldBeFrozen()) {
                this.authorizationExecutor.canFreeze(context, project);
                project.setFrozen(true);
                freezingFlags.freeze();
            }
            if (update.shouldBeFrozenForExperiments()) {
                this.authorizationExecutor.canFreeze(context, project);
                project.setFrozenForExperiment(true);
                freezingFlags.freezeForExperiments();
            }
            if (update.shouldBeFrozenForSamples()) {
                this.authorizationExecutor.canFreeze(context, project);
                project.setFrozenForSample(true);
                freezingFlags.freezeForSamples();
            }
            if (freezingFlags.noFlags()) continue;
            freezingEvents.add(new FreezingEvent(project.getIdentifier(), EventPE.EntityType.PROJECT, freezingFlags));
        }
        if (!freezingEvents.isEmpty()) {
            this.eventExecutor.persist(context, freezingEvents);
        }
    }

    private void updateAttachments(final IOperationContext context, MapBatch<ProjectUpdate, ProjectPE> batch) {
        new MapBatchProcessor<ProjectUpdate, ProjectPE>(context, batch){

            @Override
            public void process(ProjectUpdate update, ProjectPE entity) {
                if (update.getAttachments() != null && update.getAttachments().hasActions()) {
                    UpdateProjectExecutor.this.updateProjectAttachmentExecutor.update(context, entity, update.getAttachments());
                }
            }

            @Override
            public IProgress createProgress(ProjectUpdate update, ProjectPE entity, int objectIndex, int totalObjectCount) {
                return new UpdateRelationProgress((IUpdate)update, entity, "project-attachment", objectIndex, totalObjectCount);
            }
        };
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<ProjectUpdate, ProjectPE> batch) {
    }

    @Override
    protected Map<IProjectId, ProjectPE> map(IOperationContext context, Collection<IProjectId> ids) {
        return this.mapProjectByIdExecutor.map(context, ids);
    }

    @Override
    protected List<ProjectPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getProjectDAO().listByIDs(ids);
    }

    @Override
    protected void save(IOperationContext context, List<ProjectPE> entities, boolean clearCache) {
        for (ProjectPE entity : entities) {
            this.daoFactory.getProjectDAO().validateAndSaveUpdatedEntity(entity);
        }
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "project", null);
    }
}

