/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.FieldUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.update.ProjectUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.ISpaceId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityToOneRelationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IReindexEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IUpdateProjectSpaceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.IMapSpaceByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SimpleSpaceValidator;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateProjectSpaceExecutor
extends AbstractUpdateEntityToOneRelationExecutor<ProjectUpdate, ProjectPE, ISpaceId, SpacePE>
implements IUpdateProjectSpaceExecutor {
    @Autowired
    private IMapSpaceByIdExecutor mapSpaceByIdExecutor;
    @Autowired
    private IReindexEntityExecutor reindexObjectExecutor;

    @Override
    protected String getRelationName() {
        return "project-space";
    }

    @Override
    public void update(IOperationContext context, MapBatch<ProjectUpdate, ProjectPE> batch) {
        super.update(context, batch);
        this.reindex(context, ((Map)batch.getObjects()).values());
    }

    @Override
    public void update(IOperationContext context, MapBatch<ProjectUpdate, ProjectPE> batch, Map<ISpaceId, SpacePE> relatedMap) {
        super.update(context, batch, relatedMap);
        this.reindex(context, ((Map)batch.getObjects()).values());
    }

    @Override
    protected ISpaceId getRelatedId(SpacePE related) {
        return new SpacePermId(related.getCode());
    }

    @Override
    protected SpacePE getCurrentlyRelated(ProjectPE entity) {
        return entity.getSpace();
    }

    @Override
    protected FieldUpdateValue<ISpaceId> getRelatedUpdate(ProjectUpdate update) {
        return update.getSpaceId();
    }

    @Override
    protected Map<ISpaceId, SpacePE> map(IOperationContext context, List<ISpaceId> relatedIds) {
        return this.mapSpaceByIdExecutor.map(context, relatedIds);
    }

    @Override
    protected void check(IOperationContext context, ProjectPE entity, ISpaceId relatedId, SpacePE related) {
        if (!new SimpleSpaceValidator().doValidation(context.getSession().tryGetPerson(), related)) {
            throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
        }
    }

    @Override
    protected void update(IOperationContext context, ProjectPE entity, SpacePE related) {
        if (related == null) {
            throw new UserFailureException("Space id cannot be null");
        }
        this.relationshipService.assignProjectToSpace(context.getSession(), entity, related);
    }

    private void reindex(IOperationContext context, Collection<ProjectPE> projects) {
        HashSet<ExperimentPE> experiments = new HashSet<ExperimentPE>();
        for (ProjectPE project : projects) {
            experiments.addAll(project.getExperiments());
        }
        this.reindexObjectExecutor.reindex(context, ExperimentPE.class, experiments);
    }
}

