/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.delete.PropertyTypeDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.IPropertyTypeId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IDeletePropertyTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IMapPropertyTypeByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IPropertyTypeAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IPropertyTypeBO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeletePropertyTypeExecutor
extends AbstractDeleteEntityExecutor<Void, IPropertyTypeId, PropertyTypePE, PropertyTypeDeletionOptions>
implements IDeletePropertyTypeExecutor {
    @Resource(name="common-business-object-factory")
    private ICommonBusinessObjectFactory businessObjectFactory;
    @Autowired
    private IPropertyTypeAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IMapPropertyTypeByIdExecutor mapPropertyTypeByIdExeceutor;

    @Override
    protected Map<IPropertyTypeId, PropertyTypePE> map(IOperationContext context, List<? extends IPropertyTypeId> entityIds, PropertyTypeDeletionOptions deletionOptions) {
        return this.mapPropertyTypeByIdExeceutor.map(context, entityIds);
    }

    @Override
    protected void checkAccess(IOperationContext context, IPropertyTypeId entityId, PropertyTypePE entity) {
        this.authorizationExecutor.canDelete(context, entityId, entity);
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, PropertyTypePE entity) {
    }

    @Override
    protected Void delete(IOperationContext context, Collection<PropertyTypePE> entities, PropertyTypeDeletionOptions deletionOptions) {
        IPropertyTypeBO propertyTypeBO = this.businessObjectFactory.createPropertyTypeBO(context.getSession());
        String reason = deletionOptions.getReason();
        for (PropertyTypePE propertyType : entities) {
            propertyTypeBO.deleteByTechId(new TechId(propertyType.getId()), reason);
        }
        return null;
    }
}

