/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.IEntityTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.IPropertyAssignmentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.IPropertyTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyAssignmentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnsupportedObjectIdException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IMapEntityTypeByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IMapPropertyAssignmentByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IMapPropertyTypeByIdExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MapPropertyAssignmentByIdExecutor
implements IMapPropertyAssignmentByIdExecutor {
    @Autowired
    private IMapEntityTypeByIdExecutor mapEntityTypeByIdExecutor;
    @Autowired
    private IMapPropertyTypeByIdExecutor mapPropertyTypeByIdExecutor;

    @Override
    public Map<IPropertyAssignmentId, EntityTypePropertyTypePE> map(IOperationContext context, Collection<? extends IPropertyAssignmentId> ids) {
        return this.map(context, ids, true);
    }

    @Override
    public Map<IPropertyAssignmentId, EntityTypePropertyTypePE> map(IOperationContext context, Collection<? extends IPropertyAssignmentId> ids, boolean checkAccess) {
        HashSet<IEntityTypeId> entityTypeIds = new HashSet<IEntityTypeId>();
        HashSet<IPropertyTypeId> propertyTypeIds = new HashSet<IPropertyTypeId>();
        for (IPropertyAssignmentId iPropertyAssignmentId : ids) {
            if (iPropertyAssignmentId instanceof PropertyAssignmentPermId) {
                PropertyAssignmentPermId permId = (PropertyAssignmentPermId)iPropertyAssignmentId;
                entityTypeIds.add(permId.getEntityTypeId());
                propertyTypeIds.add(permId.getPropertyTypeId());
                continue;
            }
            throw new UnsupportedObjectIdException((IObjectId)iPropertyAssignmentId);
        }
        Map<IEntityTypeId, EntityTypePE> entityTypes = this.mapEntityTypeByIdExecutor.map(context, null, entityTypeIds);
        Map map = this.mapPropertyTypeByIdExecutor.map(context, propertyTypeIds, checkAccess);
        HashMap<IPropertyAssignmentId, EntityTypePropertyTypePE> propertyAssignments = new HashMap<IPropertyAssignmentId, EntityTypePropertyTypePE>();
        for (IPropertyAssignmentId iPropertyAssignmentId : ids) {
            PropertyAssignmentPermId permId = (PropertyAssignmentPermId)iPropertyAssignmentId;
            EntityTypePE entityType = entityTypes.get(permId.getEntityTypeId());
            PropertyTypePE propertyType = (PropertyTypePE)map.get(permId.getPropertyTypeId());
            if (entityType == null || propertyType == null) continue;
            for (EntityTypePropertyTypePE entityTypePropertyTypePE : entityType.getEntityTypePropertyTypes()) {
                if (!propertyType.equals(entityTypePropertyTypePE.getPropertyType())) continue;
                propertyAssignments.put(iPropertyAssignmentId, entityTypePropertyTypePE);
            }
        }
        return propertyAssignments;
    }
}

