/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.DataType;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.Progress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IPropertiesConverter;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.Batch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.property.IPropertyQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.lemnik.eodsql.QueryTool;
import org.springframework.stereotype.Component;

@Component
public class PropertiesConverter
implements IPropertiesConverter {
    @Override
    public void convertProperties(IOperationContext context, String propertyTypeCode, DataType currentDataType, DataType newDataType) {
        IPropertyQuery query = (IPropertyQuery)QueryTool.getManagedQuery(IPropertyQuery.class);
        List<IPropertiesListerAndUpdater> listerUpdaters = Arrays.asList(new ExperimentPropertyUpdater(), new SamplePropertyUpdater(), new DataSetPropertyUpdater());
        if (currentDataType == DataType.TIMESTAMP && newDataType == DataType.DATE) {
            this.convert(context, query, listerUpdaters, new TimestampToDatePropertyConverter(), propertyTypeCode);
        } else if (currentDataType == DataType.CONTROLLEDVOCABULARY && EnumSet.of(DataType.VARCHAR, DataType.MULTILINE_VARCHAR).contains(newDataType)) {
            this.convert(context, query, listerUpdaters, new VocabularyToVarcharPropertyConverter(), propertyTypeCode);
        } else if (currentDataType == DataType.SAMPLE && EnumSet.of(DataType.VARCHAR, DataType.MULTILINE_VARCHAR).contains(newDataType)) {
            this.convert(context, query, listerUpdaters, new SampleToVarcharPropertyConverter(), propertyTypeCode);
        }
    }

    private void convert(IOperationContext context, IPropertyQuery query, List<IPropertiesListerAndUpdater> listerUpdaters, final AbstractPropertyConverter converter, String propertyTypeCode) {
        for (IPropertiesListerAndUpdater listerUpdater : listerUpdaters) {
            List<PropertyRecord> properties = listerUpdater.listProperties(query, propertyTypeCode);
            for (CollectionBatch<PropertyRecord> batch : Batch.createBatches(properties)) {
                final ArrayList<PropertyRecord> convertedProperties = new ArrayList<PropertyRecord>();
                new CollectionBatchProcessor<PropertyRecord>(context, batch){

                    @Override
                    public void process(PropertyRecord property) {
                        convertedProperties.add(converter.convertProperty(property));
                    }

                    @Override
                    public IProgress createProgress(PropertyRecord property, int objectIndex, int totalObjectCount) {
                        return new Progress(String.valueOf(property.objectId), objectIndex, totalObjectCount);
                    }
                };
                listerUpdater.updateProperties(query, convertedProperties);
            }
        }
    }

    private static class SampleToVarcharPropertyConverter
    extends AbstractPropertyConverter {
        private SampleToVarcharPropertyConverter() {
        }

        @Override
        void convert(PropertyRecord convertedProperty, PropertyRecord property) {
            convertedProperty.propertyValue = property.sample_perm_id;
        }
    }

    private static class VocabularyToVarcharPropertyConverter
    extends AbstractPropertyConverter {
        private VocabularyToVarcharPropertyConverter() {
        }

        @Override
        void convert(PropertyRecord convertedProperty, PropertyRecord property) {
            convertedProperty.propertyValue = property.vocabularyPropertyValue;
        }
    }

    private static class TimestampToDatePropertyConverter
    extends AbstractPropertyConverter {
        private TimestampToDatePropertyConverter() {
        }

        @Override
        void convert(PropertyRecord convertedProperty, PropertyRecord property) {
            convertedProperty.propertyValue = property.propertyValue.split(" ")[0];
        }
    }

    private static abstract class AbstractPropertyConverter {
        private AbstractPropertyConverter() {
        }

        PropertyRecord convertProperty(PropertyRecord property) {
            PropertyRecord convertedProperty = new PropertyRecord();
            convertedProperty.objectId = property.objectId;
            this.convert(convertedProperty, property);
            return convertedProperty;
        }

        abstract void convert(PropertyRecord var1, PropertyRecord var2);
    }

    private static class DataSetPropertyUpdater
    implements IPropertiesListerAndUpdater {
        private DataSetPropertyUpdater() {
        }

        @Override
        public List<PropertyRecord> listProperties(IPropertyQuery query, String propertyTypeCode) {
            return query.listDataSetProperties(propertyTypeCode);
        }

        @Override
        public void updateProperties(IPropertyQuery query, List<PropertyRecord> convertedProperties) {
            query.updateDataSetProperties(convertedProperties);
        }
    }

    private static class SamplePropertyUpdater
    implements IPropertiesListerAndUpdater {
        private SamplePropertyUpdater() {
        }

        @Override
        public List<PropertyRecord> listProperties(IPropertyQuery query, String propertyTypeCode) {
            return query.listSampleProperties(propertyTypeCode);
        }

        @Override
        public void updateProperties(IPropertyQuery query, List<PropertyRecord> convertedProperties) {
            query.updateSampleProperties(convertedProperties);
        }
    }

    private static class ExperimentPropertyUpdater
    implements IPropertiesListerAndUpdater {
        private ExperimentPropertyUpdater() {
        }

        @Override
        public List<PropertyRecord> listProperties(IPropertyQuery query, String propertyTypeCode) {
            return query.listExperimentProperties(propertyTypeCode);
        }

        @Override
        public void updateProperties(IPropertyQuery query, List<PropertyRecord> convertedProperties) {
            query.updateExperimentProperties(convertedProperties);
        }
    }

    private static interface IPropertiesListerAndUpdater {
        public List<PropertyRecord> listProperties(IPropertyQuery var1, String var2);

        public void updateProperties(IPropertyQuery var1, List<PropertyRecord> var2);
    }
}

