/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.IPropertyTypeId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IPropertyTypeAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.business.bo.InternalPropertyTypeAuthorization;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import org.springframework.stereotype.Component;

@Component
public class PropertyTypeAuthorizationExecutor
implements IPropertyTypeAuthorizationExecutor {
    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="GET_PROPERTY_TYPE")
    public void canGet(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="SEARCH_PROPERTY_TYPE")
    public void canSearch(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="CREATE_PROPERTY_TYPE")
    public void canCreate(IOperationContext context, PropertyTypePE entity) {
        new InternalPropertyTypeAuthorization().canCreatePropertyType(context.getSession(), entity);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="UPDATE_PROPERTY_TYPE")
    public void canUpdate(IOperationContext context, IPropertyTypeId id, PropertyTypePE entity) {
        new InternalPropertyTypeAuthorization().canUpdatePropertyType(context.getSession(), entity);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="DELETE_PROPERTY_TYPE")
    public void canDelete(IOperationContext context, IPropertyTypeId entityId, PropertyTypePE entity) {
        new InternalPropertyTypeAuthorization().canDeletePropertyType(context.getSession(), entity);
    }
}

