/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdsSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.IEntityTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.search.EntityTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.IPropertyAssignmentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.IPropertyTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyAssignmentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.search.PropertyAssignmentSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.search.PropertyTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.search.SemanticAnnotationSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.ISearchEntityTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.ISearchPropertyAssignmentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.ISearchPropertyTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.semanticannotation.ISearchSemanticAnnotationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.EntityKindConverter;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SemanticAnnotationPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchPropertyAssignmentExecutor
extends AbstractSearchObjectManuallyExecutor<PropertyAssignmentSearchCriteria, EntityTypePropertyTypePE>
implements ISearchPropertyAssignmentExecutor {
    @Autowired
    private ISearchEntityTypeExecutor searchEntityTypeExecutor;
    @Autowired
    private ISearchPropertyTypeExecutor searchPropertyTypeExecutor;
    @Autowired
    private ISearchSemanticAnnotationExecutor searchSemanticAnnotationExecutor;

    @Override
    protected List<EntityTypePropertyTypePE> listAll() {
        ArrayList<EntityTypePropertyTypePE> propertyAssignments = new ArrayList<EntityTypePropertyTypePE>();
        propertyAssignments.addAll(this.daoFactory.getEntityPropertyTypeDAO(EntityKind.MATERIAL).listEntityPropertyTypes());
        propertyAssignments.addAll(this.daoFactory.getEntityPropertyTypeDAO(EntityKind.EXPERIMENT).listEntityPropertyTypes());
        propertyAssignments.addAll(this.daoFactory.getEntityPropertyTypeDAO(EntityKind.SAMPLE).listEntityPropertyTypes());
        propertyAssignments.addAll(this.daoFactory.getEntityPropertyTypeDAO(EntityKind.DATA_SET).listEntityPropertyTypes());
        return propertyAssignments;
    }

    @Override
    protected Matcher<EntityTypePropertyTypePE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof IdsSearchCriteria) {
            return new IdsMatcher();
        }
        if (criteria instanceof EntityTypeSearchCriteria) {
            return new EntityTypeMatcher();
        }
        if (criteria instanceof PropertyTypeSearchCriteria) {
            return new PropertyTypeMatcher();
        }
        if (criteria instanceof SemanticAnnotationSearchCriteria) {
            return new SemanticAnnotationMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private void checkEntityTypeId(IEntityTypeId entityTypeId) {
        if (entityTypeId == null) {
            throw new UserFailureException("Property assignment entity type id cannot be null");
        }
        if (!(entityTypeId instanceof EntityTypePermId)) {
            throw new IllegalArgumentException("Unknown id: " + entityTypeId.getClass());
        }
        EntityTypePermId entityTypePermId = (EntityTypePermId)entityTypeId;
        if (entityTypePermId.getPermId() == null) {
            throw new UserFailureException("Entity type perm id cannot be null");
        }
        if (entityTypePermId.getEntityKind() == null) {
            throw new UserFailureException("Entity type entity kind cannot be null");
        }
    }

    private void checkPropertyTypeId(IPropertyTypeId propertyTypeId) {
        if (propertyTypeId == null) {
            throw new UserFailureException("Property assignment property type id cannot be null");
        }
        if (!(propertyTypeId instanceof PropertyTypePermId)) {
            throw new IllegalArgumentException("Unknown id: " + propertyTypeId.getClass());
        }
        PropertyTypePermId propertyTypePermId = (PropertyTypePermId)propertyTypeId;
        if (propertyTypePermId.getPermId() == null) {
            throw new UserFailureException("Property type perm id cannot be null");
        }
    }

    private class SemanticAnnotationMatcher
    extends Matcher<EntityTypePropertyTypePE> {
        private SemanticAnnotationMatcher() {
        }

        @Override
        public List<EntityTypePropertyTypePE> getMatching(IOperationContext context, List<EntityTypePropertyTypePE> assignments, ISearchCriteria criteria) {
            List<EntityTypePropertyTypePE> sampleAssignments = this.getSampleAssignments(assignments);
            List<SemanticAnnotationPE> annotations = SearchPropertyAssignmentExecutor.this.searchSemanticAnnotationExecutor.search(context, (SemanticAnnotationSearchCriteria)criteria);
            Set<PropertyTypePE> propertyTypesWithMatchingAnnotations = this.getPropertyTypesWithMatchingAnnotations(context, sampleAssignments, annotations);
            Set<EntityTypePropertyTypePE> assignmentsWithMatchingAnnotations = this.getAssignmentsWithMatchingAnnotations(context, sampleAssignments, annotations);
            Set<EntityTypePropertyTypePE> assignmentsWithoutAnyAnnotations = this.getAssignmentsWithoutAnyAnnotations(context, sampleAssignments);
            HashSet<EntityTypePropertyTypePE> matching = new HashSet<EntityTypePropertyTypePE>();
            matching.addAll(assignmentsWithMatchingAnnotations);
            for (EntityTypePropertyTypePE assignmentWithoutAnyAnnotations : assignmentsWithoutAnyAnnotations) {
                if (!propertyTypesWithMatchingAnnotations.contains(assignmentWithoutAnyAnnotations.getPropertyType())) continue;
                matching.add(assignmentWithoutAnyAnnotations);
            }
            return new ArrayList<EntityTypePropertyTypePE>(matching);
        }

        private List<EntityTypePropertyTypePE> getSampleAssignments(List<EntityTypePropertyTypePE> assignments) {
            ArrayList<EntityTypePropertyTypePE> sampleAssignments = new ArrayList<EntityTypePropertyTypePE>();
            for (EntityTypePropertyTypePE assignment : assignments) {
                if (!EntityKind.SAMPLE.equals((Object)assignment.getEntityType().getEntityKind())) continue;
                sampleAssignments.add(assignment);
            }
            return sampleAssignments;
        }

        private Set<PropertyTypePE> getPropertyTypesWithMatchingAnnotations(IOperationContext context, List<EntityTypePropertyTypePE> assignments, List<SemanticAnnotationPE> annotations) {
            HashSet<PropertyTypePE> propertyTypesSet = new HashSet<PropertyTypePE>();
            HashSet<PropertyTypePE> propertyTypesWithAnnotations = new HashSet<PropertyTypePE>();
            for (EntityTypePropertyTypePE assignment : assignments) {
                propertyTypesSet.add(assignment.getPropertyType());
            }
            for (SemanticAnnotationPE annotation : annotations) {
                if (annotation.getPropertyType() == null || !propertyTypesSet.contains(annotation.getPropertyType())) continue;
                propertyTypesWithAnnotations.add(annotation.getPropertyType());
            }
            return propertyTypesWithAnnotations;
        }

        private Set<EntityTypePropertyTypePE> getAssignmentsWithMatchingAnnotations(IOperationContext context, List<EntityTypePropertyTypePE> assignments, List<SemanticAnnotationPE> annotations) {
            HashSet<EntityTypePropertyTypePE> assignmentsSet = new HashSet<EntityTypePropertyTypePE>(assignments);
            HashSet<EntityTypePropertyTypePE> assignmentsWithAnnotations = new HashSet<EntityTypePropertyTypePE>();
            for (SemanticAnnotationPE annotation : annotations) {
                if (annotation.getSampleTypePropertyType() == null || !assignmentsSet.contains(annotation.getSampleTypePropertyType())) continue;
                assignmentsWithAnnotations.add(annotation.getSampleTypePropertyType());
            }
            return assignmentsWithAnnotations;
        }

        private Set<EntityTypePropertyTypePE> getAssignmentsWithoutAnyAnnotations(IOperationContext context, List<EntityTypePropertyTypePE> assignments) {
            List allAnnotations = SearchPropertyAssignmentExecutor.this.searchSemanticAnnotationExecutor.search(context, new SemanticAnnotationSearchCriteria());
            HashSet<EntityTypePropertyTypePE> assignmentsWithoutAnyAnnotations = new HashSet<EntityTypePropertyTypePE>(assignments);
            for (SemanticAnnotationPE annotation : allAnnotations) {
                if (annotation.getSampleTypePropertyType() == null) continue;
                assignmentsWithoutAnyAnnotations.remove(annotation.getSampleTypePropertyType());
            }
            return assignmentsWithoutAnyAnnotations;
        }
    }

    private class PropertyTypeMatcher
    extends Matcher<EntityTypePropertyTypePE> {
        private PropertyTypeMatcher() {
        }

        @Override
        public List<EntityTypePropertyTypePE> getMatching(IOperationContext context, List<EntityTypePropertyTypePE> objects, ISearchCriteria criteria) {
            List propertyTypeList = SearchPropertyAssignmentExecutor.this.searchPropertyTypeExecutor.search(context, (PropertyTypeSearchCriteria)criteria);
            HashSet propertyTypeSet = new HashSet(propertyTypeList);
            ArrayList<EntityTypePropertyTypePE> matching = new ArrayList<EntityTypePropertyTypePE>();
            for (EntityTypePropertyTypePE object : objects) {
                if (!propertyTypeSet.contains(object.getPropertyType())) continue;
                matching.add(object);
            }
            return matching;
        }
    }

    private class EntityTypeMatcher
    extends Matcher<EntityTypePropertyTypePE> {
        private EntityTypeMatcher() {
        }

        @Override
        public List<EntityTypePropertyTypePE> getMatching(IOperationContext context, List<EntityTypePropertyTypePE> objects, ISearchCriteria criteria) {
            List entityTypeList = SearchPropertyAssignmentExecutor.this.searchEntityTypeExecutor.search(context, (EntityTypeSearchCriteria)criteria);
            HashSet entityTypeSet = new HashSet(entityTypeList);
            ArrayList<EntityTypePropertyTypePE> matching = new ArrayList<EntityTypePropertyTypePE>();
            for (EntityTypePropertyTypePE object : objects) {
                if (!entityTypeSet.contains(object.getEntityType())) continue;
                matching.add(object);
            }
            return matching;
        }
    }

    private class IdsMatcher
    extends Matcher<EntityTypePropertyTypePE> {
        private IdsMatcher() {
        }

        @Override
        public List<EntityTypePropertyTypePE> getMatching(IOperationContext context, List<EntityTypePropertyTypePE> objects, ISearchCriteria criteria) {
            Collection ids = (Collection)((IdsSearchCriteria)criteria).getFieldValue();
            if (ids != null && !ids.isEmpty()) {
                for (IPropertyAssignmentId id : ids) {
                    if (id instanceof PropertyAssignmentPermId) {
                        PropertyAssignmentPermId permId = (PropertyAssignmentPermId)id;
                        SearchPropertyAssignmentExecutor.this.checkEntityTypeId(permId.getEntityTypeId());
                        SearchPropertyAssignmentExecutor.this.checkPropertyTypeId(permId.getPropertyTypeId());
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown id: " + id.getClass());
                }
                HashSet idsSet = new HashSet(ids);
                ArrayList<EntityTypePropertyTypePE> matches = new ArrayList<EntityTypePropertyTypePE>();
                for (EntityTypePropertyTypePE object : objects) {
                    PropertyTypePermId propertyTypeId;
                    EntityTypePermId entityTypeId = new EntityTypePermId(object.getEntityType().getCode(), EntityKindConverter.convert(object.getEntityType().getEntityKind()));
                    PropertyAssignmentPermId propertyAssignmentId = new PropertyAssignmentPermId((IEntityTypeId)entityTypeId, (IPropertyTypeId)(propertyTypeId = new PropertyTypePermId(object.getPropertyType().getCode())));
                    if (!idsSet.contains(propertyAssignmentId)) continue;
                    matches.add(object);
                }
                return matches;
            }
            return new ArrayList<EntityTypePropertyTypePE>();
        }
    }

    private class IdMatcher
    extends Matcher<EntityTypePropertyTypePE> {
        private IdMatcher() {
        }

        @Override
        public List<EntityTypePropertyTypePE> getMatching(IOperationContext context, List<EntityTypePropertyTypePE> objects, ISearchCriteria criteria) {
            IPropertyAssignmentId id = (IPropertyAssignmentId)((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return objects;
            }
            IdsSearchCriteria idsCriteria = new IdsSearchCriteria();
            idsCriteria.thatIn(Arrays.asList(id));
            return new IdsMatcher().getMatching(context, objects, (ISearchCriteria)idsCriteria);
        }
    }
}

