/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdsSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.search.PropertyTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.search.SemanticAnnotationSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractIdMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractIdsMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodeMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodesMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IPropertyTypeAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.ISearchPropertyTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.semanticannotation.ISearchSemanticAnnotationExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SemanticAnnotationPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchPropertyTypeExecutor
extends AbstractSearchObjectManuallyExecutor<PropertyTypeSearchCriteria, PropertyTypePE>
implements ISearchPropertyTypeExecutor {
    @Autowired
    private IPropertyTypeAuthorizationExecutor authorizationExecutor;
    @Autowired
    private ISearchSemanticAnnotationExecutor searchSemanticAnnotationExecutor;

    @Override
    public List<PropertyTypePE> search(IOperationContext context, PropertyTypeSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<PropertyTypePE> listAll() {
        return this.daoFactory.getPropertyTypeDAO().listAllEntities();
    }

    @Override
    protected Matcher<PropertyTypePE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof IdsSearchCriteria) {
            return new IdsMatcher();
        }
        if (criteria instanceof CodeSearchCriteria) {
            return new CodeMatcher<PropertyTypePE>();
        }
        if (criteria instanceof CodesSearchCriteria) {
            return new CodesMatcher<PropertyTypePE>();
        }
        if (criteria instanceof SemanticAnnotationSearchCriteria) {
            return new SemanticAnnotationMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class SemanticAnnotationMatcher
    extends Matcher<PropertyTypePE> {
        private SemanticAnnotationMatcher() {
        }

        @Override
        public List<PropertyTypePE> getMatching(IOperationContext context, List<PropertyTypePE> objects, ISearchCriteria criteria) {
            List annotations = SearchPropertyTypeExecutor.this.searchSemanticAnnotationExecutor.search(context, (SemanticAnnotationSearchCriteria)criteria);
            HashSet<PropertyTypePE> propertyTypesSet = new HashSet<PropertyTypePE>(objects);
            HashSet<PropertyTypePE> matches = new HashSet<PropertyTypePE>();
            for (SemanticAnnotationPE annotation : annotations) {
                if (annotation.getPropertyType() == null || !propertyTypesSet.contains(annotation.getPropertyType())) continue;
                matches.add(annotation.getPropertyType());
            }
            return new ArrayList<PropertyTypePE>(matches);
        }
    }

    private class IdsMatcher
    extends AbstractIdsMatcher<PropertyTypePE> {
        private IdsMatcher() {
        }

        @Override
        protected boolean addPermIdIfPossible(Collection<String> permIds, IObjectId id) {
            if (!(id instanceof PropertyTypePermId)) {
                return false;
            }
            permIds.add(((PropertyTypePermId)id).getPermId());
            return true;
        }
    }

    private class IdMatcher
    extends AbstractIdMatcher<PropertyTypePE> {
        private IdMatcher() {
        }

        @Override
        protected AbstractIdsMatcher<PropertyTypePE> createIdsMatcher() {
            return new IdsMatcher();
        }
    }
}

