/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPropertiesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IUpdateEntityPropertyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IMapSampleByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.EntityProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.UpdatePropertyProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleAuthorizationValidator;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.EntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyWithSampleDataTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateEntityPropertyExecutor
implements IUpdateEntityPropertyExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IEntityInformationProvider entityInformationProvider;
    @Autowired
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;
    @Autowired
    private IMapSampleByIdExecutor mapSampleByIdExecutor;
    @Autowired
    private ISampleAuthorizationValidator sampleAuthorizationValidator;

    private UpdateEntityPropertyExecutor() {
    }

    public UpdateEntityPropertyExecutor(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this.daoFactory = daoFactory;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    @Override
    public void update(final IOperationContext context, MapBatch<? extends IPropertiesHolder, ? extends IEntityInformationWithPropertiesHolder> holderToEntityMap) {
        MapBatch<IEntityInformationWithPropertiesHolder, Map<String, String>> entityToPropertiesMap = this.getEntityToPropertiesMap(holderToEntityMap);
        if (entityToPropertiesMap == null || entityToPropertiesMap.isEmpty()) {
            return;
        }
        MapBatch<IEntityInformationWithPropertiesHolder, Map<String, ISampleId>> entityToSamplePropertiesMap = this.extractAndRemoveSampleProperties(holderToEntityMap, entityToPropertiesMap);
        this.updateSampleProps(context, entityToSamplePropertiesMap);
        final HashMap converters = new HashMap();
        new MapBatchProcessor<IEntityInformationWithPropertiesHolder, Map<String, String>>(context, entityToPropertiesMap){

            @Override
            public void process(IEntityInformationWithPropertiesHolder propertiesHolder, Map<String, String> properties) {
                EntityKind entityKind = propertiesHolder.getEntityType().getEntityKind();
                if (converters.get((Object)entityKind) == null) {
                    EntityPropertiesConverter converter = new EntityPropertiesConverter(entityKind, UpdateEntityPropertyExecutor.this.daoFactory, UpdateEntityPropertyExecutor.this.entityInformationProvider, UpdateEntityPropertyExecutor.this.managedPropertyEvaluatorFactory);
                    converters.put(entityKind, converter);
                }
                UpdateEntityPropertyExecutor.this.update(context, propertiesHolder, properties, (EntityPropertiesConverter)converters.get((Object)entityKind));
            }

            @Override
            public IProgress createProgress(IEntityInformationWithPropertiesHolder propertiesHolder, Map<String, String> properties, int objectIndex, int totalObjectCount) {
                return new UpdatePropertyProgress(propertiesHolder, properties, objectIndex, totalObjectCount);
            }
        };
    }

    private void updateSampleProps(final IOperationContext context, MapBatch<IEntityInformationWithPropertiesHolder, Map<String, ISampleId>> entityToSamplePropertiesMap) {
        if (entityToSamplePropertiesMap != null && !entityToSamplePropertiesMap.isEmpty()) {
            final Map<ISampleId, SamplePE> samplesById = this.getSamples(context, entityToSamplePropertiesMap);
            new MapBatchProcessor<IEntityInformationWithPropertiesHolder, Map<String, ISampleId>>(context, entityToSamplePropertiesMap){

                @Override
                public void process(IEntityInformationWithPropertiesHolder entity, Map<String, ISampleId> properties) {
                    Map existingPropertiesByCode = UpdateEntityPropertyExecutor.this.getExistingPropertiesByCode(entity);
                    Map entityTypePropertyTypeByPropertyType = UpdateEntityPropertyExecutor.this.getEntityTypePropertyTypeByPropertyType(entity);
                    UpdateEntityPropertyExecutor.this.updateProperties(context, entity, properties, samplesById, existingPropertiesByCode, entityTypePropertyTypeByPropertyType);
                }

                @Override
                public IProgress createProgress(IEntityInformationWithPropertiesHolder key, Map<String, ISampleId> value, int objectIndex, int totalObjectCount) {
                    return new EntityProgress("update properties of type sample", key, objectIndex, totalObjectCount);
                }
            };
        }
    }

    private void updateProperties(IOperationContext context, IEntityInformationWithPropertiesHolder entity, Map<String, ISampleId> properties, Map<ISampleId, SamplePE> samplesById, Map<String, EntityPropertyPE> existingPropertiesByCode, Map<String, EntityTypePropertyTypePE> entityTypePropertyTypeByPropertyType) {
        for (Map.Entry<String, ISampleId> property : properties.entrySet()) {
            EntityTypePropertyTypePE entityProperty;
            String propertyCode = property.getKey();
            EntityTypePropertyTypePE etpt = entityTypePropertyTypeByPropertyType.get(propertyCode);
            if (etpt == null) {
                throw new UserFailureException("Not a property of data type SAMPLE: " + propertyCode);
            }
            EntityPropertyPE existingProperty = existingPropertiesByCode.get(propertyCode);
            ISampleId sampleId = property.getValue();
            SamplePE sample = this.validateAndGetSample(samplesById, sampleId, etpt, propertyCode);
            if (existingProperty != null) {
                if (sample == null) {
                    if (!existingProperty.getEntityTypePropertyType().isMandatory()) {
                        entity.removeProperty(existingProperty);
                        continue;
                    }
                    throw new UserFailureException("Property " + propertyCode + " of entity type " + etpt.getEntityType().getCode() + " can not be deleted because it is mandatory.");
                }
                if (!(existingProperty instanceof EntityPropertyWithSampleDataTypePE)) continue;
                ((EntityPropertyWithSampleDataTypePE)existingProperty).setSampleValue(sample);
                continue;
            }
            if (sample == null || !((entityProperty = EntityPropertyPE.createEntityProperty(entity.getEntityKind())) instanceof EntityPropertyWithSampleDataTypePE)) continue;
            PersonPE registrator = context.getSession().tryGetPerson();
            entityProperty.setRegistrator(registrator);
            ((EntityPropertyPE)((Object)entityProperty)).setAuthor(registrator);
            ((EntityPropertyPE)((Object)entityProperty)).setEntityTypePropertyType((EntityTypePropertyTypePE)etpt);
            ((EntityPropertyWithSampleDataTypePE)((Object)entityProperty)).setSampleValue(sample);
            entity.addProperty((EntityPropertyPE)((Object)entityProperty));
        }
    }

    private SamplePE validateAndGetSample(Map<ISampleId, SamplePE> samplesById, ISampleId sampleId, EntityTypePropertyTypePE etpt, String propertyCode) {
        if (sampleId == null) {
            return null;
        }
        SamplePE sample = samplesById.get(sampleId);
        if (sample == null) {
            throw new UserFailureException("Unknown sample: " + sampleId);
        }
        SampleTypePE sampleType = etpt.getPropertyType().getSampleType();
        if (sampleType != null && !sampleType.getCode().equals(sample.getSampleType().getCode())) {
            throw new UserFailureException("Property " + propertyCode + " is not a sample of type " + sampleType.getCode() + " but of type " + sample.getSampleType().getCode());
        }
        return sample;
    }

    private Map<String, EntityPropertyPE> getExistingPropertiesByCode(IEntityInformationWithPropertiesHolder entity) {
        HashMap<String, EntityPropertyPE> existingPropertiesByCode = new HashMap<String, EntityPropertyPE>();
        for (EntityPropertyPE entityProperty : entity.getProperties()) {
            PropertyTypePE propertyType = entityProperty.getEntityTypePropertyType().getPropertyType();
            existingPropertiesByCode.put(propertyType.getCode(), entityProperty);
        }
        return existingPropertiesByCode;
    }

    private Map<String, EntityTypePropertyTypePE> getEntityTypePropertyTypeByPropertyType(IEntityInformationWithPropertiesHolder entity) {
        HashMap<String, EntityTypePropertyTypePE> entityTypePropertyTypeByPropertyType = new HashMap<String, EntityTypePropertyTypePE>();
        for (EntityTypePropertyTypePE entityTypePropertyTypePE : entity.getEntityType().getEntityTypePropertyTypes()) {
            PropertyTypePE propertyType = entityTypePropertyTypePE.getPropertyType();
            if (!DataTypeCode.SAMPLE.equals((Object)propertyType.getType().getCode())) continue;
            entityTypePropertyTypeByPropertyType.put(propertyType.getCode(), entityTypePropertyTypePE);
        }
        return entityTypePropertyTypeByPropertyType;
    }

    private Map<ISampleId, SamplePE> getSamples(IOperationContext context, MapBatch<IEntityInformationWithPropertiesHolder, Map<String, ISampleId>> entityToSamplePropertiesMap) {
        Set<ISampleId> sampleIds = this.getSampleIds(entityToSamplePropertiesMap);
        Map samplesById = this.mapSampleByIdExecutor.map(context, sampleIds);
        Set<Long> validateSampleTechIds = this.sampleAuthorizationValidator.validate(context.getSession().tryGetPerson(), samplesById.values().stream().map(SamplePE::getId).collect(Collectors.toSet()));
        return samplesById.entrySet().stream().filter(e -> validateSampleTechIds.contains(((SamplePE)e.getValue()).getId())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Set<ISampleId> getSampleIds(MapBatch<IEntityInformationWithPropertiesHolder, Map<String, ISampleId>> entityToSamplePropertiesMap) {
        HashSet<ISampleId> sampleIds = new HashSet<ISampleId>();
        for (Map map : ((Map)entityToSamplePropertiesMap.getObjects()).values()) {
            Collection values = map.values();
            for (ISampleId sample : values) {
                if (sample == null) continue;
                sampleIds.add(sample);
            }
        }
        return sampleIds;
    }

    private MapBatch<IEntityInformationWithPropertiesHolder, Map<String, ISampleId>> extractAndRemoveSampleProperties(MapBatch<? extends IPropertiesHolder, ? extends IEntityInformationWithPropertiesHolder> holderToEntityMap, MapBatch<IEntityInformationWithPropertiesHolder, Map<String, String>> entityToPropertiesMap) {
        HashMap<IEntityInformationWithPropertiesHolder, HashMap<String, SampleIdentifier>> map = new HashMap<IEntityInformationWithPropertiesHolder, HashMap<String, SampleIdentifier>>();
        Map objects = (Map)entityToPropertiesMap.getObjects();
        for (Map.Entry entry : objects.entrySet()) {
            IEntityInformationWithPropertiesHolder entity = (IEntityInformationWithPropertiesHolder)entry.getKey();
            Collection<? extends EntityTypePropertyTypePE> etpts = entity.getEntityType().getEntityTypePropertyTypes();
            for (EntityTypePropertyTypePE entityTypePropertyTypePE : etpts) {
                HashMap<String, SampleIdentifier> props;
                if (entityTypePropertyTypePE.getPropertyType().getType().getCode() != DataTypeCode.SAMPLE) continue;
                String code = entityTypePropertyTypePE.getPropertyType().getCode();
                Map properties = (Map)entry.getValue();
                if (!properties.containsKey(code)) continue;
                String sample = (String)properties.remove(code);
                SampleIdentifier sampleId = null;
                if (sample != null) {
                    Object object = sampleId = sample.startsWith("/") ? new SampleIdentifier(sample) : new SamplePermId(sample);
                }
                if ((props = (HashMap<String, SampleIdentifier>)map.get(entity)) == null) {
                    props = new HashMap<String, SampleIdentifier>();
                    map.put(entity, props);
                }
                props.put(code, sampleId);
            }
        }
        return new MapBatch<IEntityInformationWithPropertiesHolder, Map<String, ISampleId>>(holderToEntityMap.getBatchIndex(), holderToEntityMap.getFromObjectIndex(), holderToEntityMap.getToObjectIndex(), (Map<IEntityInformationWithPropertiesHolder, Map<String, ISampleId>>)map, holderToEntityMap.getTotalObjectCount());
    }

    private MapBatch<IEntityInformationWithPropertiesHolder, Map<String, String>> getEntityToPropertiesMap(MapBatch<? extends IPropertiesHolder, ? extends IEntityInformationWithPropertiesHolder> holderToEntityMap) {
        if (holderToEntityMap == null || holderToEntityMap.isEmpty()) {
            return null;
        }
        HashMap<IEntityInformationWithPropertiesHolder, Map> entityToPropertiesMap = new HashMap<IEntityInformationWithPropertiesHolder, Map>();
        for (Map.Entry entry : ((Map)holderToEntityMap.getObjects()).entrySet()) {
            IPropertiesHolder holder = (IPropertiesHolder)entry.getKey();
            IEntityInformationWithPropertiesHolder entity = (IEntityInformationWithPropertiesHolder)entry.getValue();
            if (holder.getProperties() == null || holder.getProperties().isEmpty()) continue;
            entityToPropertiesMap.put(entity, holder.getProperties());
        }
        if (entityToPropertiesMap.isEmpty()) {
            return null;
        }
        return new MapBatch<IEntityInformationWithPropertiesHolder, Map<String, String>>(holderToEntityMap.getBatchIndex(), holderToEntityMap.getFromObjectIndex(), holderToEntityMap.getToObjectIndex(), (Map<IEntityInformationWithPropertiesHolder, Map<String, String>>)entityToPropertiesMap, holderToEntityMap.getTotalObjectCount());
    }

    private void update(IOperationContext context, IEntityPropertiesHolder propertiesHolder, Map<String, String> properties, EntityPropertiesConverter converter) {
        LinkedList<IEntityProperty> entityProperties = new LinkedList<IEntityProperty>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            entityProperties.add(EntityHelper.createNewProperty(entry.getKey(), entry.getValue()));
        }
        Set<? extends EntityPropertyPE> existingProperties = propertiesHolder.getProperties();
        HashMap<String, Object> existingPropertyValuesByCode = new HashMap<String, Object>();
        for (EntityPropertyPE entityPropertyPE : existingProperties) {
            String propertyCode = entityPropertyPE.getEntityTypePropertyType().getPropertyType().getCode();
            existingPropertyValuesByCode.put(propertyCode, UpdateEntityPropertyExecutor.getValue(entityPropertyPE));
        }
        Set<? extends EntityPropertyPE> convertedProperties = this.convertProperties(context, propertiesHolder.getEntityType(), existingProperties, entityProperties, converter);
        if (!UpdateEntityPropertyExecutor.isEquals(existingPropertyValuesByCode, convertedProperties)) {
            propertiesHolder.setProperties(convertedProperties);
        }
    }

    private <T extends EntityPropertyPE> Set<T> convertProperties(IOperationContext context, EntityTypePE type, Set<T> existingProperties, List<IEntityProperty> properties, EntityPropertiesConverter converter) {
        HashSet<String> propertiesToUpdate = new HashSet<String>();
        if (properties != null) {
            for (IEntityProperty property : properties) {
                propertiesToUpdate.add(property.getPropertyType().getCode());
            }
        }
        return converter.updateProperties(existingProperties, type, properties, context.getSession().tryGetPerson(), propertiesToUpdate);
    }

    private static Object getValue(EntityPropertyPE property) {
        String value = property.getValue();
        if (value != null) {
            return value;
        }
        MaterialPE materialValue = property.getMaterialValue();
        if (materialValue != null) {
            return materialValue;
        }
        return property.getVocabularyTerm();
    }

    private static boolean isEquals(Map<String, Object> existingPropertyValuesByCode, Set<? extends EntityPropertyPE> properties) {
        for (EntityPropertyPE entityPropertyPE : properties) {
            Object existingValue = existingPropertyValuesByCode.remove(entityPropertyPE.getEntityTypePropertyType().getPropertyType().getCode());
            if (existingValue != null && existingValue.equals(UpdateEntityPropertyExecutor.getValue(entityPropertyPE))) continue;
            return false;
        }
        return existingPropertyValuesByCode.isEmpty();
    }
}

