/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.ListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.DataType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.IPropertyTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.update.PropertyTypeUpdate;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.CreatePropertyTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IMapPropertyTypeByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IPropertiesConverter;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IPropertyTypeAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IUpdatePropertyTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.UpdateRelationProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class UpdatePropertyTypeExecutor
extends AbstractUpdateEntityExecutor<PropertyTypeUpdate, PropertyTypePE, IPropertyTypeId, PropertyTypePermId>
implements IUpdatePropertyTypeExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapPropertyTypeByIdExecutor mapPropertyTypeByIdExecutor;
    @Autowired
    private IPropertyTypeAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IPropertiesConverter propertiesConverter;

    @Override
    protected IPropertyTypeId getId(PropertyTypeUpdate update) {
        return update.getTypeId();
    }

    @Override
    protected PropertyTypePermId getPermId(PropertyTypePE entity) {
        return new PropertyTypePermId(entity.getPermId());
    }

    @Override
    protected void checkData(IOperationContext context, PropertyTypeUpdate update) {
        if (update.getTypeId() == null) {
            throw new UserFailureException("Property type id cannot be null.");
        }
        if (update.getLabel().isModified() && StringUtils.isEmpty((CharSequence)((CharSequence)update.getLabel().getValue()))) {
            throw new UserFailureException("Label cannot be empty.");
        }
        if (update.getDescription().isModified() && StringUtils.isEmpty((CharSequence)((CharSequence)update.getDescription().getValue()))) {
            throw new UserFailureException("Description cannot be empty.");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context, IPropertyTypeId id, PropertyTypePE entity) {
        this.authorizationExecutor.canUpdate(context, id, entity);
    }

    @Override
    protected void updateBatch(final IOperationContext context, MapBatch<PropertyTypeUpdate, PropertyTypePE> batch) {
        new MapBatchProcessor<PropertyTypeUpdate, PropertyTypePE>(context, batch){

            @Override
            public void process(PropertyTypeUpdate update, PropertyTypePE propertyType) {
                propertyType.setDescription((String)UpdatePropertyTypeExecutor.this.getNewValue(update.getDescription(), propertyType.getDescription()));
                propertyType.setLabel((String)UpdatePropertyTypeExecutor.this.getNewValue(update.getLabel(), propertyType.getLabel()));
                String dataType = propertyType.getType().getCode().name();
                DataType dataTypeToBeConverted = update.getDataTypeToBeConverted();
                if (dataTypeToBeConverted != null && !dataTypeToBeConverted.name().equals(dataType)) {
                    DataType currentDataType = DataType.valueOf((String)dataType);
                    this.assertConversionAllowed(currentDataType, dataTypeToBeConverted);
                    DataTypePE newDataType = UpdatePropertyTypeExecutor.this.daoFactory.getPropertyTypeDAO().getDataTypeByCode(DataTypeCode.valueOf((String)dataTypeToBeConverted.name()));
                    propertyType.setType(newDataType);
                    UpdatePropertyTypeExecutor.this.propertiesConverter.convertProperties(context, propertyType.getCode(), currentDataType, dataTypeToBeConverted);
                }
                CreatePropertyTypeExecutor.validateSchemaAndDataType(dataType, (String)update.getSchema().getValue());
                propertyType.setSchema((String)UpdatePropertyTypeExecutor.this.getNewValue(update.getSchema(), propertyType.getSchema()));
                CreatePropertyTypeExecutor.validateTransformationAndDataType(dataType, (String)update.getTransformation().getValue());
                propertyType.setTransformation((String)UpdatePropertyTypeExecutor.this.getNewValue(update.getTransformation(), propertyType.getTransformation()));
                this.updateMetaData(propertyType, update);
            }

            private void assertConversionAllowed(DataType currentDataType, DataType newDataType) {
                if (EnumSet.of(DataType.VARCHAR, DataType.MULTILINE_VARCHAR).contains(newDataType)) {
                    return;
                }
                this.assertConversionAllowed(currentDataType, newDataType, DataType.TIMESTAMP, DataType.DATE);
                this.assertConversionAllowed(currentDataType, newDataType, DataType.INTEGER, DataType.REAL);
            }

            private void assertConversionAllowed(DataType currentDataType, DataType newDataType, DataType matchingCurrentDataType, DataType matchingNewDataType) {
                if (newDataType == matchingNewDataType && currentDataType != matchingCurrentDataType) {
                    throw new UserFailureException("Only properties of type " + matchingCurrentDataType + " can be converted to " + newDataType + ", but not " + currentDataType + ".");
                }
            }

            private void updateMetaData(PropertyTypePE propertyType, PropertyTypeUpdate update) {
                HashMap<String, String> metaData = new HashMap<String, String>();
                if (propertyType.getMetaData() != null) {
                    metaData.putAll(propertyType.getMetaData());
                }
                ListUpdateValue.ListUpdateActionSet lastSetAction = null;
                AtomicBoolean metaDataChanged = new AtomicBoolean(false);
                for (ListUpdateValue.ListUpdateAction action : update.getMetaData().getActions()) {
                    if (action instanceof ListUpdateValue.ListUpdateActionAdd) {
                        this.addTo(metaData, action, metaDataChanged);
                        continue;
                    }
                    if (action instanceof ListUpdateValue.ListUpdateActionRemove) {
                        for (String key : action.getItems()) {
                            metaDataChanged.set(true);
                            metaData.remove(key);
                        }
                        continue;
                    }
                    if (!(action instanceof ListUpdateValue.ListUpdateActionSet)) continue;
                    lastSetAction = (ListUpdateValue.ListUpdateActionSet)action;
                }
                if (lastSetAction != null) {
                    metaData.clear();
                    this.addTo((Map<String, String>)metaData, (ListUpdateValue.ListUpdateAction<?>)lastSetAction, metaDataChanged);
                }
                if (metaDataChanged.get()) {
                    propertyType.setMetaData(metaData.isEmpty() ? null : metaData);
                }
            }

            private void addTo(Map<String, String> metaData, ListUpdateValue.ListUpdateAction<?> lastSetAction, AtomicBoolean metaDataChanged) {
                Collection maps = lastSetAction.getItems();
                for (Map map : maps) {
                    if (map.isEmpty()) continue;
                    metaDataChanged.set(true);
                    metaData.putAll(map);
                }
            }

            @Override
            public IProgress createProgress(PropertyTypeUpdate key, PropertyTypePE value, int objectIndex, int totalObjectCount) {
                return new UpdateRelationProgress((IUpdate)key, value, "property type", objectIndex, totalObjectCount);
            }
        };
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<PropertyTypeUpdate, PropertyTypePE> batch) {
    }

    @Override
    protected Map<IPropertyTypeId, PropertyTypePE> map(IOperationContext context, Collection<IPropertyTypeId> ids) {
        return this.mapPropertyTypeByIdExecutor.map(context, ids);
    }

    @Override
    protected List<PropertyTypePE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getPropertyTypeDAO().listAllEntities();
    }

    @Override
    protected void save(IOperationContext context, List<PropertyTypePE> entities, boolean clearCache) {
        for (PropertyTypePE propertyType : entities) {
            this.daoFactory.getPropertyTypeDAO().validateAndSaveUpdatedEntity(propertyType);
        }
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "property types", null);
    }
}

