/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property;

import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IVerifyEntityPropertyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.VerifyProgress;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.EntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VerifyEntityPropertyExecutor
implements IVerifyEntityPropertyExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IEntityInformationProvider entityInformationProvider;
    @Autowired
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    private VerifyEntityPropertyExecutor() {
    }

    public VerifyEntityPropertyExecutor(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this.daoFactory = daoFactory;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    @Override
    public void verify(IOperationContext context, CollectionBatch<? extends IEntityInformationWithPropertiesHolder> batch) {
        final HashMap cache = new HashMap();
        new CollectionBatchProcessor<IEntityInformationWithPropertiesHolder>(context, batch){

            @Override
            public void process(IEntityInformationWithPropertiesHolder entity) {
                EntityPropertiesConverter converter = VerifyEntityPropertyExecutor.this.getEntityPropertiesConverter(entity.getEntityKind());
                converter.checkMandatoryProperties(entity.getProperties(), entity.getEntityType(), cache);
            }

            @Override
            public IProgress createProgress(IEntityInformationWithPropertiesHolder object, int objectIndex, int totalObjectCount) {
                return new VerifyProgress(object, objectIndex, totalObjectCount);
            }
        };
    }

    private EntityPropertiesConverter getEntityPropertiesConverter(EntityKind entityKindOrNull) {
        return new EntityPropertiesConverter(entityKindOrNull, this.daoFactory, this.entityInformationProvider, this.managedPropertyEvaluatorFactory);
    }
}

