/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.TableModel;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.IQueryDatabaseId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.IQueryId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IMapQueryByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IMapQueryDatabaseByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IQueryAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.TableModelTranslator;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.QueryPE;
import ch.systemsx.cisd.openbis.plugin.query.server.DAO;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.QueryAccessController;
import ch.systemsx.cisd.openbis.plugin.query.shared.DatabaseDefinition;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryParameterBindings;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;

public class AbstractExecuteExecutor {
    @Autowired
    protected IQueryAuthorizationExecutor authorizationExecutor;
    @Autowired
    protected IMapQueryByIdExecutor mapQueryByIdExecutor;
    @Autowired
    protected IMapQueryDatabaseByIdExecutor mapQueryDatabaseByIdExecutor;
    @Autowired
    protected IDAOFactory daoFactory;

    protected QueryPE getQuery(IOperationContext context, IQueryId queryId) {
        Map queries = this.mapQueryByIdExecutor.map(context, Arrays.asList(queryId));
        QueryPE query = (QueryPE)queries.get(queryId);
        if (query == null) {
            throw new ObjectNotFoundException((IObjectId)queryId);
        }
        return query;
    }

    protected DatabaseDefinition getDatabase(IOperationContext context, IQueryDatabaseId databaseId) {
        Map databases = this.mapQueryDatabaseByIdExecutor.map(context, Arrays.asList(databaseId));
        DatabaseDefinition database = (DatabaseDefinition)databases.get(databaseId);
        if (database == null) {
            throw new ObjectNotFoundException((IObjectId)databaseId);
        }
        return database;
    }

    protected TableModel doExecute(IOperationContext context, String sql, DatabaseDefinition database, Map<String, String> parameters) {
        try {
            DAO databaseDAO = new DAO(database.getConfigurationContext().getDataSource());
            QueryParameterBindings bindings = new QueryParameterBindings();
            if (parameters != null) {
                bindings.setBindings(parameters);
            }
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel tableModel = databaseDAO.query(sql, bindings);
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel filteredTableModel = QueryAccessController.filterResults(context.getSession().tryGetPerson(), database.getKey(), this.daoFactory, tableModel);
            return new TableModelTranslator().translate(filteredTableModel);
        }
        catch (DataAccessException ex) {
            throw new UserFailureException(ex.getMostSpecificCause().getMessage(), (Throwable)ex);
        }
    }
}

