/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.TableModel;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.execute.QueryExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.IQueryDatabaseId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.IQueryId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.QueryDatabaseName;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.AbstractExecuteExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IExecuteQueryExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.QueryPE;
import ch.systemsx.cisd.openbis.plugin.query.shared.DatabaseDefinition;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.stereotype.Component;

@Component
public class ExecuteQueryExecutor
extends AbstractExecuteExecutor
implements IExecuteQueryExecutor {
    @Override
    public TableModel execute(IOperationContext context, IQueryId queryId, QueryExecutionOptions options) {
        if (queryId == null) {
            throw new UserFailureException("Query id cannot be null");
        }
        if (options == null) {
            throw new UserFailureException("Query execution options cannot be null");
        }
        QueryPE query = this.getQuery(context, queryId);
        DatabaseDefinition database = this.getDatabase(context, (IQueryDatabaseId)new QueryDatabaseName(query.getQueryDatabaseKey()));
        this.authorizationExecutor.canExecute(context, queryId, query);
        return this.doExecute(context, StringEscapeUtils.unescapeHtml4((String)query.getExpression()), database, options.getParameters());
    }
}

