/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.IQueryDatabaseId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.QueryDatabaseName;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnsupportedObjectIdException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IMapQueryDatabaseByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IQueryDatabaseAuthorizationExecutor;
import ch.systemsx.cisd.openbis.plugin.query.shared.DatabaseDefinition;
import ch.systemsx.cisd.openbis.plugin.query.shared.IQueryDatabaseDefinitionProviderAutoInitialized;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MapQueryDatabaseByIdExecutor
implements IMapQueryDatabaseByIdExecutor {
    @Autowired
    private IQueryDatabaseAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IQueryDatabaseDefinitionProviderAutoInitialized databaseProvider;

    @Override
    public Map<IQueryDatabaseId, DatabaseDefinition> map(IOperationContext context, Collection<? extends IQueryDatabaseId> ids) {
        this.authorizationExecutor.canGet(context);
        LinkedHashMap<IQueryDatabaseId, DatabaseDefinition> result = new LinkedHashMap<IQueryDatabaseId, DatabaseDefinition>();
        for (IQueryDatabaseId iQueryDatabaseId : ids) {
            if (iQueryDatabaseId instanceof QueryDatabaseName) {
                String name = ((QueryDatabaseName)iQueryDatabaseId).getName();
                DatabaseDefinition definition = this.databaseProvider.getDefinition(name);
                if (definition == null) continue;
                result.put(iQueryDatabaseId, definition);
                continue;
            }
            throw new UnsupportedObjectIdException((IObjectId)iQueryDatabaseId);
        }
        return result;
    }

    @Override
    public Map<IQueryDatabaseId, DatabaseDefinition> map(IOperationContext context, Collection<? extends IQueryDatabaseId> ids, boolean checkAccess) {
        return this.map(context, ids);
    }
}

