/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.IQueryId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.QueryDatabaseName;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IQueryAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.roleassignment.RoleAssignmentUtils;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseCreateOrDeleteModification;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseUpdateModification;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.QueryPE;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.QueryAccessController;
import ch.systemsx.cisd.openbis.plugin.query.shared.DatabaseDefinition;
import ch.systemsx.cisd.openbis.plugin.query.shared.IQueryDatabaseDefinitionProviderAutoInitialized;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryAuthorizationExecutor
implements IQueryAuthorizationExecutor {
    @Autowired
    private IQueryDatabaseDefinitionProviderAutoInitialized databaseProvider;

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="CREATE_QUERY")
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.QUERY})
    public void canCreate(IOperationContext context, QueryPE query) {
        this.canWrite(context, null, query, "create");
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="UPDATE_QUERY")
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.QUERY})
    public void canUpdate(IOperationContext context, IQueryId id, QueryPE query) {
        this.canWrite(context, id, query, "update");
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="DELETE_QUERY")
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.QUERY})
    public void canDelete(IOperationContext context, IQueryId id, QueryPE query) {
        this.canWrite(context, id, query, "delete");
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public void canExecute(IOperationContext context, IQueryId id, QueryPE query) {
        this.checkDatabaseExists(query.getQueryDatabaseKey());
        if (query.isPublic() || context.getSession().tryGetPerson().equals(query.getRegistrator()) || RoleAssignmentUtils.isInstanceAdmin(context.getSession().tryGetPerson())) {
            try {
                QueryAccessController.checkReadAccess(context.getSession(), query.getQueryDatabaseKey());
            }
            catch (AuthorizationFailureException e) {
                throw new UnauthorizedObjectAccessException((IObjectId)new QueryDatabaseName(query.getQueryDatabaseKey()));
            }
        } else {
            throw new UnauthorizedObjectAccessException((IObjectId)id);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="EXECUTE_QUERY")
    public void canExecute(IOperationContext context, String sql, DatabaseDefinition database) {
        this.checkDatabaseExists(database.getKey());
        try {
            QueryAccessController.checkWriteAccess(context.getSession(), database.getKey(), "create and perform");
        }
        catch (AuthorizationFailureException e) {
            throw new UnauthorizedObjectAccessException((IObjectId)new QueryDatabaseName(database.getKey()));
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="GET_QUERY")
    public void canGet(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="SEARCH_QUERY")
    public void canSearch(IOperationContext context) {
    }

    private void canWrite(IOperationContext context, IQueryId id, QueryPE query, String operation) {
        this.checkDatabaseExists(query.getQueryDatabaseKey());
        if (query.isPublic() || context.getSession().tryGetPerson().equals(query.getRegistrator()) || RoleAssignmentUtils.isInstanceAdmin(context.getSession().tryGetPerson())) {
            try {
                QueryAccessController.checkWriteAccess(context.getSession(), query.getQueryDatabaseKey(), operation);
            }
            catch (AuthorizationFailureException e) {
                throw new UnauthorizedObjectAccessException((IObjectId)new QueryDatabaseName(query.getQueryDatabaseKey()));
            }
        } else {
            throw new UnauthorizedObjectAccessException((IObjectId)id);
        }
    }

    private void checkDatabaseExists(String databaseKey) {
        DatabaseDefinition database = this.databaseProvider.getDefinition(databaseKey);
        if (database == null) {
            throw new ObjectNotFoundException((IObjectId)new QueryDatabaseName(databaseKey));
        }
    }
}

