/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.QueryDatabaseName;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.search.QueryDatabaseSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IQueryDatabaseAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.ISearchQueryDatabaseExecutor;
import ch.systemsx.cisd.openbis.plugin.query.shared.DatabaseDefinition;
import ch.systemsx.cisd.openbis.plugin.query.shared.IQueryDatabaseDefinitionProviderAutoInitialized;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchQueryDatabaseExecutor
extends AbstractSearchObjectManuallyExecutor<QueryDatabaseSearchCriteria, DatabaseDefinition>
implements ISearchQueryDatabaseExecutor {
    @Autowired
    private IQueryDatabaseAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IQueryDatabaseDefinitionProviderAutoInitialized databaseProvider;

    @Override
    public List<DatabaseDefinition> search(IOperationContext context, QueryDatabaseSearchCriteria criteria) {
        this.authorizationExecutor.canGet(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<DatabaseDefinition> listAll() {
        ArrayList<DatabaseDefinition> definitions = new ArrayList<DatabaseDefinition>(this.databaseProvider.getAllDefinitions());
        definitions.sort(new Comparator<DatabaseDefinition>(){

            @Override
            public int compare(DatabaseDefinition o1, DatabaseDefinition o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return definitions;
    }

    @Override
    protected Matcher<DatabaseDefinition> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class IdMatcher
    extends SimpleFieldMatcher<DatabaseDefinition> {
        private IdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, DatabaseDefinition object, ISearchCriteria criteria) {
            IObjectId id = ((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof QueryDatabaseName) {
                return id.equals(new QueryDatabaseName(object.getKey()));
            }
            throw new IllegalArgumentException("Unknown id: " + id.getClass());
        }
    }
}

