/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DescriptionSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NameSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.QueryType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.QueryDatabaseName;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.QueryName;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.QueryTechId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.search.DatabaseIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.search.EntityTypeCodePatternSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.search.QuerySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.search.QueryTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.search.SqlSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.StringFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IQueryAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.ISearchQueryExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.QueryPE;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchQueryExecutor
extends AbstractSearchObjectManuallyExecutor<QuerySearchCriteria, QueryPE>
implements ISearchQueryExecutor {
    @Autowired
    private IQueryAuthorizationExecutor authorizationExecutor;

    @Override
    public List<QueryPE> search(IOperationContext context, QuerySearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<QueryPE> listAll() {
        return this.daoFactory.getQueryDAO().listAllEntities();
    }

    @Override
    protected Matcher<QueryPE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof DatabaseIdSearchCriteria) {
            return new DatabaseIdMatcher();
        }
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof NameSearchCriteria) {
            return new NameMatcher();
        }
        if (criteria instanceof QueryTypeSearchCriteria) {
            return new QueryTypeMatcher();
        }
        if (criteria instanceof DescriptionSearchCriteria) {
            return new DescriptionMatcher();
        }
        if (criteria instanceof EntityTypeCodePatternSearchCriteria) {
            return new EntityTypeCodePatternMatcher();
        }
        if (criteria instanceof SqlSearchCriteria) {
            return new SqlMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class SqlMatcher
    extends StringFieldMatcher<QueryPE> {
        private SqlMatcher() {
        }

        @Override
        protected String getFieldValue(QueryPE object) {
            return object.getExpression();
        }
    }

    private class DescriptionMatcher
    extends StringFieldMatcher<QueryPE> {
        private DescriptionMatcher() {
        }

        @Override
        protected String getFieldValue(QueryPE object) {
            return object.getDescription();
        }
    }

    private class EntityTypeCodePatternMatcher
    extends StringFieldMatcher<QueryPE> {
        private EntityTypeCodePatternMatcher() {
        }

        @Override
        protected String getFieldValue(QueryPE object) {
            return object.getEntityTypeCodePattern();
        }
    }

    private class QueryTypeMatcher
    extends SimpleFieldMatcher<QueryPE> {
        private QueryTypeMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, QueryPE object, ISearchCriteria criteria) {
            QueryTypeSearchCriteria queryTypeCriteria = (QueryTypeSearchCriteria)criteria;
            if (queryTypeCriteria.getFieldValue() == null) {
                return true;
            }
            return ((QueryType)queryTypeCriteria.getFieldValue()).name().equals(object.getQueryType().name());
        }
    }

    private class NameMatcher
    extends StringFieldMatcher<QueryPE> {
        private NameMatcher() {
        }

        @Override
        protected String getFieldValue(QueryPE object) {
            return object.getName();
        }
    }

    private class DatabaseIdMatcher
    extends SimpleFieldMatcher<QueryPE> {
        private DatabaseIdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, QueryPE object, ISearchCriteria criteria) {
            IObjectId id = ((DatabaseIdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof QueryDatabaseName) {
                return id.equals(new QueryDatabaseName(object.getQueryDatabaseKey()));
            }
            throw new IllegalArgumentException("Unknown id: " + id.getClass());
        }
    }

    private class IdMatcher
    extends SimpleFieldMatcher<QueryPE> {
        private IdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, QueryPE object, ISearchCriteria criteria) {
            IObjectId id = ((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof QueryTechId) {
                return id.equals(new QueryTechId(object.getId()));
            }
            if (id instanceof QueryName) {
                return id.equals(new QueryName(object.getName()));
            }
            throw new IllegalArgumentException("Unknown id: " + id.getClass());
        }
    }
}

