/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.IQueryId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.QueryTechId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.update.QueryUpdate;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IMapQueryByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IQueryAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IUpdateQueryDatabaseExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IUpdateQueryExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.QueryType;
import ch.systemsx.cisd.openbis.generic.shared.dto.QueryPE;
import ch.systemsx.cisd.openbis.plugin.query.server.DAO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class UpdateQueryExecutor
extends AbstractUpdateEntityExecutor<QueryUpdate, QueryPE, IQueryId, QueryTechId>
implements IUpdateQueryExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapQueryByIdExecutor mapQueryByIdExecutor;
    @Autowired
    private IUpdateQueryDatabaseExecutor updateQueryDatabaseExecutor;
    @Autowired
    private IQueryAuthorizationExecutor authorizationExecutor;

    @Override
    protected IQueryId getId(QueryUpdate update) {
        return update.getQueryId();
    }

    @Override
    protected QueryTechId getPermId(QueryPE entity) {
        return new QueryTechId(entity.getId());
    }

    @Override
    protected void checkData(IOperationContext context, QueryUpdate update) {
        if (update.getQueryId() == null) {
            throw new UserFailureException("Query id cannot be null.");
        }
        if (update.getName() != null && update.getName().isModified() && StringUtils.isEmpty((CharSequence)((CharSequence)update.getName().getValue()))) {
            throw new UserFailureException("Name cannot be empty.");
        }
        if (update.getDatabaseId() != null && update.getDatabaseId().isModified() && update.getDatabaseId().getValue() == null) {
            throw new UserFailureException("Database id cannot be null.");
        }
        if (update.getSql() != null && update.getSql().isModified()) {
            if (StringUtils.isEmpty((CharSequence)((CharSequence)update.getSql().getValue()))) {
                throw new UserFailureException("Sql cannot be empty.");
            }
            DAO.checkQuery((String)update.getSql().getValue());
        }
        if (update.getQueryType() != null && update.getQueryType().isModified() && update.getQueryType().getValue() == null) {
            throw new UserFailureException("Query type cannot be null.");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context, IQueryId id, QueryPE entity) {
        this.authorizationExecutor.canUpdate(context, id, entity);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<QueryUpdate, QueryPE> batch) {
        this.updateQueryDatabaseExecutor.update(context, batch);
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            QueryUpdate update = (QueryUpdate)entry.getKey();
            QueryPE query = (QueryPE)entry.getValue();
            query.setName(this.getNewValue(update.getName(), query.getName()));
            query.setDescription(this.getNewValue(update.getDescription(), query.getDescription()));
            query.setEntityTypeCodePattern(this.getNewValue(update.getEntityTypeCodePattern(), query.getEntityTypeCodePattern()));
            query.setExpression(this.getNewValue(update.getSql(), query.getExpression()));
            query.setPublic(this.getNewValue(update.isPublic(), query.isPublic()));
            if (update.getQueryType() != null && update.getQueryType().isModified()) {
                query.setQueryType(QueryType.valueOf(((ch.ethz.sis.openbis.generic.asapi.v3.dto.query.QueryType)update.getQueryType().getValue()).name()));
            }
            if (!QueryType.GENERIC.equals(query.getQueryType()) || StringUtils.isEmpty((CharSequence)query.getEntityTypeCodePattern())) continue;
            throw new UserFailureException("Entity type code pattern cannot be specified for a query with type " + ch.ethz.sis.openbis.generic.asapi.v3.dto.query.QueryType.GENERIC.name() + ".");
        }
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<QueryUpdate, QueryPE> batch) {
    }

    @Override
    protected Map<IQueryId, QueryPE> map(IOperationContext context, Collection<IQueryId> ids) {
        return this.mapQueryByIdExecutor.map(context, ids);
    }

    @Override
    protected List<QueryPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getQueryDAO().listByIDs(ids);
    }

    @Override
    protected void save(IOperationContext context, List<QueryPE> entities, boolean clearCache) {
        for (QueryPE entity : entities) {
            this.daoFactory.getQueryDAO().validateAndSaveUpdatedEntity(entity);
        }
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "query", null);
    }
}

