/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.relationship;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.relationship.IGetRelationshipIdExecutor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetRelationshipIdExecutor
implements IGetRelationshipIdExecutor {
    @Autowired
    private IDAOFactory daoFactory;

    private GetRelationshipIdExecutor() {
    }

    public GetRelationshipIdExecutor(IDAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public Long get(IOperationContext context, IGetRelationshipIdExecutor.RelationshipType type) {
        String code = this.getRelationshipCode(type);
        String key = this.getClass().getName() + "_" + code;
        Long result = (Long)context.getAttribute(key);
        if (result == null) {
            result = this.daoFactory.getRelationshipTypeDAO().tryFindRelationshipTypeByCode(code).getId();
            context.setAttribute(key, result);
        }
        return result;
    }

    private String getRelationshipCode(IGetRelationshipIdExecutor.RelationshipType type) {
        switch (type) {
            case PARENT_CHILD: {
                return "$PARENT_CHILD";
            }
            case CONTAINER_COMPONENT: {
                return "$CONTAINER_COMPONENT";
            }
        }
        throw new IllegalArgumentException("Unknown relationship type: " + (Object)((Object)type));
    }
}

