/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.rights;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.IProjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.rights.Right;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.rights.Rights;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.rights.fetchoptions.RightsFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IDataSetAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IMapDataSetByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IExperimentAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IMapExperimentByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IMapProjectByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IProjectAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.rights.IGetRightsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IMapSampleByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISampleAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.IMapSpaceByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.FullSampleIdentifier;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.SampleIdentifierParts;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetRightsExecutor
implements IGetRightsExecutor {
    @Autowired
    private IMapSpaceByIdExecutor mapSpaceByIdExecutor;
    @Autowired
    private IMapProjectByIdExecutor mapProjectByIdExecutor;
    @Autowired
    private IProjectAuthorizationExecutor projectAuthorizationExecutor;
    @Autowired
    private IMapSampleByIdExecutor mapSampleByIdExecutor;
    @Autowired
    private ISampleAuthorizationExecutor sampleAuthorizationExecutor;
    @Autowired
    private IMapExperimentByIdExecutor mapExperimentByIdExecutor;
    @Autowired
    private IExperimentAuthorizationExecutor experimentAuthorizationExecutor;
    @Autowired
    private IMapDataSetByIdExecutor mapDataSetByIdExecutor;
    @Autowired
    private IDataSetAuthorizationExecutor dataSetAuthorizationExecutor;

    @Override
    public Map<IObjectId, Rights> getRights(IOperationContext context, List<? extends IObjectId> objectIds, RightsFetchOptions fetchOptions) {
        HashMap<IObjectId, Rights> result = new HashMap<IObjectId, Rights>();
        Map<Class<? extends IObjectId>, IHandler> handlersByObjectIdClass = this.getHandlersByObjectIdClassMap();
        for (IObjectId iObjectId : objectIds) {
            IHandler handler;
            if (iObjectId == null || (handler = handlersByObjectIdClass.get(iObjectId.getClass())) == null) continue;
            handler.handle(iObjectId);
        }
        LinkedHashSet<IHandler> handlers = new LinkedHashSet<IHandler>(handlersByObjectIdClass.values());
        for (IHandler handler : handlers) {
            handler.addRights(context, result);
        }
        return result;
    }

    private Map<Class<? extends IObjectId>, IHandler> getHandlersByObjectIdClassMap() {
        LinkedHashMap<Class<? extends IObjectId>, IHandler> map = new LinkedHashMap<Class<? extends IObjectId>, IHandler>();
        ProjectHandler projectHandler = new ProjectHandler();
        map.put(ProjectIdentifier.class, projectHandler);
        map.put(ProjectPermId.class, projectHandler);
        SampleHandler sampleHandler = new SampleHandler();
        map.put(SampleIdentifier.class, sampleHandler);
        map.put(SamplePermId.class, sampleHandler);
        ExperimentHandler experimentHandler = new ExperimentHandler();
        map.put(ExperimentIdentifier.class, experimentHandler);
        map.put(ExperimentPermId.class, experimentHandler);
        DataSetHandler dataSetHandler = new DataSetHandler();
        map.put(DataSetPermId.class, dataSetHandler);
        return map;
    }

    private class DataSetHandler
    extends AbstractHandler<IDataSetId, DataPE> {
        DataSetHandler() {
            super(IDataSetId.class);
        }

        @Override
        Map<IDataSetId, DataPE> getEntitiesByIds(IOperationContext context, Collection<IDataSetId> ids) {
            return GetRightsExecutor.this.mapDataSetByIdExecutor.map(context, ids);
        }

        @Override
        void canUpdate(IOperationContext context, IDataSetId id, DataPE entity) {
            GetRightsExecutor.this.dataSetAuthorizationExecutor.canUpdate(context, id, entity);
        }

        @Override
        void canDelete(IOperationContext context, IDataSetId id, DataPE entity) {
            GetRightsExecutor.this.dataSetAuthorizationExecutor.canDelete(context, id, entity);
        }

        @Override
        DataPE createDummyEntity(IOperationContext context, IDataSetId id) {
            if (!(id instanceof DataSetPermId)) {
                throw new UserFailureException("Data set id of unsupported type (" + id.getClass().getName() + "): " + id);
            }
            String[] splittedDummyId = ((DataSetPermId)id).getPermId().split("/");
            DataPE dataPE = new DataPE();
            dataPE.setCode(splittedDummyId[splittedDummyId.length - 1]);
            SamplePE dummySample = new SamplePE();
            if (splittedDummyId.length > 2) {
                SpacePE space = new SpacePE();
                space.setCode(splittedDummyId[1]);
                dummySample.setSpace(space);
                if (splittedDummyId.length > 3) {
                    ProjectPE project = new ProjectPE();
                    project.setSpace(space);
                    project.setCode(splittedDummyId[2]);
                    dummySample.setProject(project);
                }
            }
            dataPE.setSample(dummySample);
            return dataPE;
        }

        @Override
        void canCreate(IOperationContext context, DataPE entity) {
            GetRightsExecutor.this.dataSetAuthorizationExecutor.canCreate(context, entity);
        }
    }

    private class ProjectHandler
    extends AbstractHandler<IProjectId, ProjectPE> {
        ProjectHandler() {
            super(IProjectId.class);
        }

        @Override
        Map<IProjectId, ProjectPE> getEntitiesByIds(IOperationContext context, Collection<IProjectId> ids) {
            return GetRightsExecutor.this.mapProjectByIdExecutor.map(context, ids);
        }

        @Override
        void canUpdate(IOperationContext context, IProjectId id, ProjectPE entity) {
            GetRightsExecutor.this.projectAuthorizationExecutor.canUpdate(context, id, entity);
        }

        @Override
        void canDelete(IOperationContext context, IProjectId id, ProjectPE entity) {
            GetRightsExecutor.this.projectAuthorizationExecutor.canDelete(context, id, entity);
        }

        @Override
        ProjectPE createDummyEntity(IOperationContext context, IProjectId id) {
            if (id instanceof ProjectPermId) {
                throw new UserFailureException("Unknown project with perm id " + id + ".");
            }
            if (!(id instanceof ProjectIdentifier)) {
                throw new UserFailureException("Project identifier of unsupported type (" + id.getClass().getName() + "): " + id);
            }
            SpacePermId spaceId = new SpacePermId(ProjectIdentifierFactory.parse(((ProjectIdentifier)id).getIdentifier()).getSpaceCode());
            SpacePE spacePE = (SpacePE)GetRightsExecutor.this.mapSpaceByIdExecutor.map(context, Arrays.asList(spaceId)).get(spaceId);
            if (spacePE == null) {
                throw new UserFailureException("Unknown space in project identifier '" + id + "'.");
            }
            ProjectPE projectPE = new ProjectPE();
            projectPE.setSpace(spacePE);
            projectPE.setCode("DUMMY");
            return projectPE;
        }

        @Override
        void canCreate(IOperationContext context, ProjectPE entity) {
            GetRightsExecutor.this.projectAuthorizationExecutor.canCreate(context, entity);
        }
    }

    private class ExperimentHandler
    extends AbstractHandler<IExperimentId, ExperimentPE> {
        ExperimentHandler() {
            super(IExperimentId.class);
        }

        @Override
        Map<IExperimentId, ExperimentPE> getEntitiesByIds(IOperationContext context, Collection<IExperimentId> ids) {
            return GetRightsExecutor.this.mapExperimentByIdExecutor.map(context, ids);
        }

        @Override
        void canUpdate(IOperationContext context, IExperimentId id, ExperimentPE entity) {
            GetRightsExecutor.this.experimentAuthorizationExecutor.canUpdate(context, id, entity);
        }

        @Override
        void canDelete(IOperationContext context, IExperimentId id, ExperimentPE entity) {
            GetRightsExecutor.this.experimentAuthorizationExecutor.canDelete(context, id, entity);
        }

        @Override
        ExperimentPE createDummyEntity(IOperationContext context, IExperimentId id) {
            if (id instanceof ExperimentPermId) {
                throw new UserFailureException("Unknown experiment with perm id " + id + ".");
            }
            if (!(id instanceof ExperimentIdentifier)) {
                throw new UserFailureException("Experiment identifier of unsupported type (" + id.getClass().getName() + "): " + id);
            }
            ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier expeId = ExperimentIdentifierFactory.parse(((ExperimentIdentifier)id).getIdentifier());
            ProjectIdentifier projectIdentifier = new ProjectIdentifier(expeId.getSpaceCode(), expeId.getProjectCode());
            ProjectPE projectPE = (ProjectPE)GetRightsExecutor.this.mapProjectByIdExecutor.map(context, Arrays.asList(projectIdentifier)).get(projectIdentifier);
            if (projectPE == null) {
                throw new UserFailureException("Unknown project in experiment identifier '" + id + "'.");
            }
            ExperimentPE experimentPE = new ExperimentPE();
            experimentPE.setProject(projectPE);
            experimentPE.setCode(expeId.getExperimentCode());
            return experimentPE;
        }

        @Override
        void canCreate(IOperationContext context, ExperimentPE entity) {
            GetRightsExecutor.this.experimentAuthorizationExecutor.canCreate(context, entity);
        }
    }

    private class SampleHandler
    extends AbstractHandler<ISampleId, SamplePE> {
        SampleHandler() {
            super(ISampleId.class);
        }

        @Override
        Map<ISampleId, SamplePE> getEntitiesByIds(IOperationContext context, Collection<ISampleId> ids) {
            return GetRightsExecutor.this.mapSampleByIdExecutor.map(context, ids);
        }

        @Override
        void canUpdate(IOperationContext context, ISampleId id, SamplePE entity) {
            GetRightsExecutor.this.sampleAuthorizationExecutor.canUpdate(context, id, entity);
        }

        @Override
        void canDelete(IOperationContext context, ISampleId id, SamplePE entity) {
            GetRightsExecutor.this.sampleAuthorizationExecutor.canDelete(context, id, entity);
        }

        @Override
        SamplePE createDummyEntity(IOperationContext context, ISampleId sampleId) {
            String projectCode;
            if (sampleId instanceof SamplePermId) {
                throw new UserFailureException("Unknown sample with perm id " + sampleId + ".");
            }
            if (!(sampleId instanceof SampleIdentifier)) {
                throw new UserFailureException("Sample identifier of unsupported type (" + sampleId.getClass().getName() + "): " + sampleId);
            }
            SpacePE homeSpace = context.getSession().tryGetHomeGroup();
            FullSampleIdentifier sampleIdentifier = new FullSampleIdentifier(((SampleIdentifier)sampleId).getIdentifier(), homeSpace == null ? null : homeSpace.getCode());
            SampleIdentifierParts parts = sampleIdentifier.getParts();
            SamplePE samplePE = new SamplePE();
            samplePE.setCode(sampleIdentifier.getSampleCode());
            String spaceCode = parts.getSpaceCodeOrNull();
            if (StringUtils.isNotBlank((CharSequence)spaceCode)) {
                SpacePermId spacePermId = new SpacePermId(spaceCode);
                SpacePE spacePE = (SpacePE)GetRightsExecutor.this.mapSpaceByIdExecutor.map(context, Arrays.asList(spacePermId)).get(spacePermId);
                if (spacePE == null) {
                    throw new UserFailureException("Unknown space in sample identifier '" + sampleId + "'.");
                }
                samplePE.setSpace(spacePE);
            }
            if (StringUtils.isNotBlank((CharSequence)(projectCode = parts.getProjectCodeOrNull()))) {
                if (StringUtils.isBlank((CharSequence)spaceCode)) {
                    throw new UserFailureException("Unknown space in sample identifier '" + sampleId + "'.");
                }
                ProjectIdentifier projectIdentifier = new ProjectIdentifier(spaceCode, projectCode);
                ProjectPE projectPE = (ProjectPE)GetRightsExecutor.this.mapProjectByIdExecutor.map(context, Arrays.asList(projectIdentifier)).get(projectIdentifier);
                if (projectPE == null) {
                    throw new UserFailureException("Unknown project in sample identifier '" + sampleId + "'.");
                }
                samplePE.setProject(projectPE);
            }
            return samplePE;
        }

        @Override
        void canCreate(IOperationContext context, SamplePE sample) {
            GetRightsExecutor.this.sampleAuthorizationExecutor.canCreate(context, sample);
        }
    }

    private static abstract class AbstractHandler<ID extends IObjectId, ENTITY>
    implements IHandler {
        private Class<ID> idClass;
        private List<ID> ids = new ArrayList<ID>();

        AbstractHandler(Class<ID> idClass) {
            this.idClass = idClass;
        }

        @Override
        public void handle(IObjectId id) {
            if (this.idClass.isAssignableFrom(id.getClass())) {
                this.ids.add(id);
            }
        }

        @Override
        public void addRights(IOperationContext context, Map<IObjectId, Rights> rightsByIds) {
            Set<ID> unknownIds = this.addRightsForKnownIdsAndReturnAllUnknownIds(context, rightsByIds);
            this.addRightsForUnknownIds(context, rightsByIds, unknownIds);
        }

        private Set<ID> addRightsForKnownIdsAndReturnAllUnknownIds(IOperationContext context, Map<IObjectId, Rights> rightsByIds) {
            Map<ID, ENTITY> entitiesByIds = this.getEntitiesByIds(context, this.ids);
            HashSet<ID> unknownIds = new HashSet<ID>(this.ids);
            for (Map.Entry<ID, ENTITY> entry : entitiesByIds.entrySet()) {
                HashSet<Right> rights = new HashSet<Right>();
                IObjectId id = (IObjectId)entry.getKey();
                ENTITY entity = entry.getValue();
                try {
                    this.canUpdate(context, id, entity);
                    rights.add(Right.UPDATE);
                }
                catch (AuthorizationFailureException authorizationFailureException) {
                    // empty catch block
                }
                try {
                    this.canDelete(context, id, entity);
                    rights.add(Right.DELETE);
                }
                catch (AuthorizationFailureException authorizationFailureException) {
                    // empty catch block
                }
                rightsByIds.put(id, new Rights(rights));
                unknownIds.remove(id);
            }
            return unknownIds;
        }

        private void addRightsForUnknownIds(IOperationContext context, Map<IObjectId, Rights> rightsByIds, Set<ID> unknownIds) {
            for (IObjectId id : unknownIds) {
                HashSet<Right> rights = new HashSet<Right>();
                try {
                    ENTITY entity = this.createDummyEntity(context, id);
                    this.canCreate(context, entity);
                    rights.add(Right.CREATE);
                }
                catch (AuthorizationFailureException authorizationFailureException) {
                    // empty catch block
                }
                rightsByIds.put(id, new Rights(rights));
            }
        }

        abstract Map<ID, ENTITY> getEntitiesByIds(IOperationContext var1, Collection<ID> var2);

        abstract void canUpdate(IOperationContext var1, ID var2, ENTITY var3);

        abstract void canDelete(IOperationContext var1, ID var2, ENTITY var3);

        abstract ENTITY createDummyEntity(IOperationContext var1, ID var2);

        abstract void canCreate(IOperationContext var1, ENTITY var2);
    }

    private static interface IHandler {
        public void handle(IObjectId var1);

        public void addRights(IOperationContext var1, Map<IObjectId, Rights> var2);
    }
}

