/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.roleassignment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.delete.RoleAssignmentDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.id.IRoleAssignmentId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.roleassignment.IDeleteRoleAssignmentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.roleassignment.IMapRoleAssignmentPEByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.roleassignment.IRoleAssignmentAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.roleassignment.RoleAssignmentUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRoleAssignmentDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteRoleAssignmentExecutor
extends AbstractDeleteEntityExecutor<Void, IRoleAssignmentId, RoleAssignmentPE, RoleAssignmentDeletionOptions>
implements IDeleteRoleAssignmentExecutor {
    @Autowired
    private IMapRoleAssignmentPEByIdExecutor mapRoleAssignmentByIdExecutor;
    @Autowired
    private IRoleAssignmentAuthorizationExecutor authorizationExecutor;

    @Override
    protected Map<IRoleAssignmentId, RoleAssignmentPE> map(IOperationContext context, List<? extends IRoleAssignmentId> entityIds, RoleAssignmentDeletionOptions deletionOptions) {
        return this.mapRoleAssignmentByIdExecutor.map(context, entityIds);
    }

    @Override
    protected void checkAccess(IOperationContext context, IRoleAssignmentId entityId, RoleAssignmentPE roleAssignment) {
        ProjectPE project = roleAssignment.getProject();
        if (project != null) {
            this.authorizationExecutor.canDeleteProjectRole(context, project);
        } else {
            SpacePE space = roleAssignment.getSpace();
            if (space != null) {
                this.authorizationExecutor.canDeleteSpaceRole(context, space);
            } else {
                this.authorizationExecutor.canDeleteInstanceRole(context);
            }
        }
        PersonPE personPE = context.getSession().tryGetPerson();
        RoleAssignmentUtils.checkForSelfreducingAdminAuthorization(roleAssignment, personPE);
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, RoleAssignmentPE entity) {
    }

    @Override
    protected Void delete(IOperationContext context, Collection<RoleAssignmentPE> entities, RoleAssignmentDeletionOptions deletionOptions) {
        IRoleAssignmentDAO roleAssignmentDAO = this.daoFactory.getRoleAssignmentDAO();
        for (RoleAssignmentPE entity : entities) {
            roleAssignmentDAO.delete(entity);
        }
        return null;
    }
}

